/**
 * Title:        Comedia Beans
 * Copyright:    Copyright (c) 2001
 * Company:      Capella Development Group
 * @author Sergey Seroukhov
 * @version 1.0
 */
package org.comedia.text;

import java.awt.Toolkit;
import javax.swing.*;
import javax.swing.text.*;

/**
 * Implements a document for numbers to restrict the user input in text editors.
 */
public class CNumericDocument extends PlainDocument {
  /**
   * The integer mode constant.
   */
  final public static int INTEGER = 0;

  /**
   * The float mode constant.
   */
  final public static int FLOAT = 1;

  /**
   * The hexdecimal mode constant.
   */
  final public static int HEXDECIMAL = 1;

  /**
   * The number input mode.
   */
  private int mode = INTEGER;

  /**
   * The modified flag.
   */
  private boolean modified = false;

  /**
   * Constructs this document with default parameters.
   */
  public CNumericDocument() {
    this(INTEGER);
  }

  /**
   * Construct whit document and assignes the main properties.
   */
  public CNumericDocument(int mode) {
    this.mode = mode;
  }

  /**
   * Checks if the current modified status.
   * @result <code>TRUE</code> if document was modified and <code>FALSE</code>
   *   otherwise.
   */
  public boolean isModified() {
    return modified;
  }

  /**
   * Sets a new modified status for this document.
   * @param modified a new modified status for this document.
   */
  public void setModified() {
    this.modified = modified;
  }

  /**
   * Inserts a new text into this document with required validation.
   * @param offset a offset position inside this document.
   * @param str a text to insert.
   * @param a an attribute for inserting text.
   */
  public void insertString(int offset, String str, AttributeSet a)
    throws BadLocationException {

    for (int i = 0; i < str.length(); i++) {
      if (str.charAt(i) >= '0' && str.charAt(i) <= '9')
        continue;
      if (mode != HEXDECIMAL && str.charAt(i) == '-')
        continue;
      if (mode == HEXDECIMAL && ((str.charAt(i) >= 'A' && str.charAt(i) <= 'F')
        || (str.charAt(i) >= 'a' && str.charAt(i) <= 'f')))
        continue;
      if (mode == FLOAT &&
        str.charAt(i) == System.getProperty("decimal.separator", ".").charAt(0))
        continue;

      Toolkit.getDefaultToolkit().beep();
      return;
    }

    modified = true;
    super.insertString(offset, str, a);
  }
}