/**
 * Title:        Comedia Beans
 * Copyright:    Copyright (c) 2001
 * Company:      Capella Development Group
 * @author Sergey Seroukhov
 * @version 1.0
 */

package org.comedia.text;

import javax.swing.text.*;

/**
 * Implements an editor kit for source code syntax highlighting.
 */
public class CSyntaxEditorKit extends StyledEditorKit {

  /**
   * Creates this class with default properties.
   */
  public CSyntaxEditorKit() {
  }

  /**
   * Create a copy of the editor kit.  This
   * allows an implementation to serve as a prototype
   * for others, so that they can be quickly created.
   * @return the copy
   */
  public Object clone() {
    return new StyledEditorKit();
  }

  /**
   * Creates an uninitialized text storage model
   * that is appropriate for this type of editor.
   * @return the model
   */
  public Document createDefaultDocument() {
    return new CSyntaxDocument();
  }

}