// copyright 2001-2002 by The Mind Electric

package electric.xml;

/**
 * <tt>Attributes</tt> is an enumeration over a collection of attributes.
 * To iterate through the collection in a typesafe way, use current(), first() and next().
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

final public class Attributes extends Nodes
  {
  // ********** CONSTRUCTION ************************************************

  /**
   * Construct an Attributes associated with the specified node list.
   * @param list The list of Attribute nodes.
   */
  public Attributes( NodeList list )
    {
    super( list );
    }

  // ********** ITERATION ***************************************************

  /**
   * Return the current Attribute, or null if there is none.
   */
  public Attribute current()
    {
    return (Attribute) currentNode();
    }

  /**
   * Move to the first Attribute and return it, or null if there is none.
   */
  public Attribute first()
    {
    return (Attribute) firstNode();
    }

  /**
   * Return the current Attribute and then advance to the next one if present.
   */
  public Attribute next()
    {
    return (Attribute) nextNode();
    }
  }