// copyright 2001-2002 by The Mind Electric

package electric.xml;

import java.io.*;
import electric.util.*;

/**
 * <tt>CData</tt> represents an XML CData section.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

final public class CData extends Text implements org.w3c.dom.CDATASection
  {
  static final String START = "<![CDATA[";
  static final String STOP = "]]>";

  // ********** CONSTRUCTION ************************************************

  /**
   * Construct a CData with the specified string.
   * @param string The comment string.
   */
  public CData( String string )
    {
    super( string );
    }

  /**
   * Construct a copy of the specified CData.
   * @param cdata The CData to copy.
   */
  public CData( CData cdata )
    {
    super( cdata );
    }

  /**
   * Construct a CData from the specified lexical analyzer.
   * @param lex The lexical analyzer.
   * @param parent The parent of this CData.
   * @throws IOException If an error occurs during parsing.
   */
  CData( Lex lex, Parent parent )
    throws IOException
    {
    super( parent );
    lex.skip( START.length() );
    String token = lex.readToPattern( STOP, Lex.CONSUME | Lex.INCLUDE );
    string = token.substring( 0, token.length() - STOP.length() );
    }

  // ********** CLONING *****************************************************

  /**
   * Return a clone of this CData.
   */
  public Object clone()
    {
    return new CData( this );
    }

  // ********** WRITING *****************************************************

  /**
   * Write myself to the specified writer.
   * @param writer The nodeWriter.
   * @throws IOException If an I/O exception occurs.
   */
  public void write( NodeWriter writer )
    throws IOException
    {
    writer.writeIndent();
    writer.write( START );
    writer.write( string );
    writer.write( STOP );
    }

  // ********** DOM *********************************************************

  /**
   * Return CDATA_SECTION_NODE.
   */
  public short getNodeType()
    {
    return CDATA_SECTION_NODE;
    }

  /**
   * Return "#cdata-section".
   */
  public String getNodeName()
    {
    return "#cdata-section";
    }
  }