// copyright 2001-2002 by The Mind Electric

package electric.xml;

/**
 * <tt>Children</tt> is an enumeration over a collection of child nodes.
 * To iterate through the collection in a typesafe way, use current(), first() and next().
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

final public class Children extends Nodes
  {
  // ********** CONSTRUCTION ************************************************

  /**
   * Construct a Children associated with the specified node list.
   * @param list The list of Child nodes.
   */
  Children( NodeList list )
    {
    super( list );
    }

  // ********** ITERATION ***************************************************

  /**
   * Return the current Child, or null if there is none.
   */
  public Child current()
    {
    return (Child) currentNode();
    }

  /**
   * Move to the first Child and return it, or null if there is none.
   */
  public Child first()
    {
    return (Child) firstNode();
    }

  /**
   * Return the current Child and then advance to the next one if present.
   */
  public Child next()
    {
    return (Child) nextNode();
    }
  }