// copyright 2001-2002 by The Mind Electric

package electric.xml.io.collections.apache;

import java.io.*;
import java.util.*;
import electric.xml.*;
import electric.xml.io.*;
import electric.xml.io.schema.*;
import electric.util.Value;

/**
 * <tt>ArrayListType</tt>
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class ArrayListType extends Type
  {
  public ArrayListType()
    {
    // don't generate client-side java bindings for these serializers
    setInhibit( true );
    }

  /**
   * @param schema
   * @throws SchemaException
   */
  public void writeSchema( Element schema )
    throws SchemaException
    {
    String xsdPrefix = Namespaces.getPrefix( schema, SchemaProperties.getDefaultSchema() , "xsd" );
    Element complexType = schema.addElement( xsdPrefix, "complexType" );
    complexType.setAttribute( "name", "arraylist" );
    Element sequence = complexType.addElement( xsdPrefix, "sequence" );
    Element element = sequence.addElement( xsdPrefix, "element" );
    element.setAttribute( "name", "item" );
    element.setAttribute( "minOccurs", "0" );
    element.setAttribute( "maxOccurs", "unbounded" );
    element.setAttribute( "type", getName( element, Object.class ) );
    }

  /**
   * @param writer
   * @param object
   * @throws IOException
   */
  public void writeObject( IWriter writer, Object object )
    throws IOException
    {
    for( Iterator iterator = ((ArrayList) object).iterator(); iterator.hasNext(); )
      writer.writeObject( "item", iterator.next() );
    }

  /**
   * @param reader
   * @param value
   * @throws IOException
   */
  public void readObject( IReader reader, Value value )
    throws IOException
    {
    IReader[] readers = reader.getReaders( "item" );
    ArrayList arrayList = (ArrayList) value.getObject();

    if( arrayList == null )
      {
      arrayList = new ArrayList();
      value.setObject( arrayList );
      }

    for( int i = 0; i < readers.length; i++ )
      arrayList.add( readers[ i ].readObject() );
    }
  }