// copyright 2001-2002 by The Mind Electric

package electric.xml.io.collections.net;

import java.io.*;
import java.util.*;
import electric.util.*;
import electric.xml.*;
import electric.xml.io.*;
import electric.xml.io.schema.*;
import electric.util.Value;

/**
 * <tt>CollectionType</tt>
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public abstract class CollectionType extends Type
  {
  protected static final Object[] NO_OBJECTS = new Object[ 0 ];
  protected static final Class OBJECT_ARRAY_CLASS = (new Object[ 0 ]).getClass();

  // ********** CONSTRUCTION ************************************************

  /**
   *
   */
  public CollectionType()
    {
    // don't generate client-side java bindings for these serializers
    setInhibit( true );
    }

  // ********** DEPENDENCIES ************************************************

  /**
   * @param dependencies
   */
  public void addDependencies( Vector dependencies )
    {
    try
      {
      dependencies.addElement( getType( OBJECT_ARRAY_CLASS ) );
      }
    catch( Exception exception )
      {
      exception.printStackTrace(); // should never happen
      }
    }

  // ********** WRITING ARRAYS **********************************************

  /**
   * @param writer
   * @param name
   * @param array
   * @throws IOException
   */
  public void writeArray( IWriter writer, String name, Object[] array )
    throws IOException
    {
    writer.writeObject( name, array );
    }

  /**
   * @param reader
   * @param name
   * @throws IOException
   */
  public Object[] readArray( IReader reader, String name )
    throws IOException
    {
    IReader arrayReader = reader.getReader( name );
    return (arrayReader == null ? NO_OBJECTS : (Object[]) arrayReader.readObject());
    }
  }