// copyright 2001-2002 by The Mind Electric
// based on source code contributed by the jaxen group, http://www.jaxen.org

package electric.xml.jaxen;

import electric.xml.*;
import java.util.*;

/**
 * <tt>AttributesIterator</tt>
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

 public class AttributesIterator implements Iterator
  {
  private Attributes attributes;
  private Attribute next;

  // ********** CONSTRUCTION ************************************************

  /**
   * @param attributes
   */
  public AttributesIterator( Attributes attributes )
    {
    this.attributes = attributes;
    }

  // ********** ITERATOR METHODS ********************************************

  /**
   *
   */
  public boolean hasNext()
    {
    findNext();
    return (next != null);
    }

  /**
   * @throws NoSuchElementExc
   */
  public Object next()
    throws NoSuchElementException
    {
    if( !hasNext() )
      throw new NoSuchElementException();

    Attribute attribute = next;
    next = null;
    findNext();
    return attribute;
    }

  /**
   *
   */
  protected void findNext()
    {
    if( next != null )
      return;

    while( attributes.current() != null )
      {
      Attribute attribute = attributes.next();

      if( validNode( attribute ) )
        {
        next = attribute;
        break;
        }
      }
    }

  /**
   * @param attribute
   */
  protected boolean validNode( Attribute attribute )
    {
    String name = attribute.getName();
    return (name == null || !name.startsWith( "xmlns" ));
    }

  /**
   * @throws UnsupportedOperationException
   */
  public void remove()
    throws UnsupportedOperationException
    {
    throw new UnsupportedOperationException();
    }
  }