// copyright 2001-2002 by The Mind Electric

package electric.xml.jaxen;

import org.jaxen.*;
import electric.xml.*;

/**
 * <tt>JaxenXPathFactory</tt>.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class JaxenXPathFactory implements IXPathFactory
  {
  /**
   * @param xpath
   * @param namespaceContext
   * @throws XPathException
   */
  public IXPath newXPath( String xpath, INamespaceContext namespaceContext )
    throws XPathException
    {
    try
      {
      JaxenXPath jaxenXPath = new JaxenXPath( xpath );

      if( namespaceContext != null )
        jaxenXPath.setNamespaceContext( new JaxenNamespaceContext( namespaceContext ) );

      return jaxenXPath;
      }
    catch( JaxenException exception )
      {
      throw new XPathException( exception.toString() );
      }
    }

  /**
   * @param xpath
   * @param namespaceContext
   * @throws XPathException
   */
  public IXPath newCachedXPath( String xpath, INamespaceContext namespaceContext )
    throws XPathException
    {
    return newXPath( xpath, namespaceContext );
    }
  }