// copyright 2001-2002 by The Mind Electric

package electric.xml.xpath;

import java.util.*;
import electric.xml.*;

/**
 * <tt>TMEXPathFactory</tt>.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class TMEXPathFactory implements IXPathFactory
  {
  private static final Hashtable xpathToNodeList = new Hashtable();

  /**
   * @param xpath
   * @param namespaceContext
   * @throws XPathException
   */
  public IXPath newXPath( String xpath, INamespaceContext namespaceContext )
    throws XPathException
    {
    return new TMEXPath( xpath, namespaceContext );
    }

  /**
   * @param xpath
   * @param namespaceContext
   * @throws XPathException
   */
  public IXPath newCachedXPath( String xpath, INamespaceContext namespaceContext )
    throws XPathException
    {
    xpath = xpath.trim();
    NodeList nodes = (NodeList) xpathToNodeList.get( xpath );

    if( nodes == null )
      xpathToNodeList.put( xpath, (nodes = XPathNodeFactory.newNodes( xpath )) );

    return new TMEXPath( xpath, nodes, namespaceContext );
    }
  }