/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;

import ch.abacus.lib.ui.renderer.common.ProjectToolPanel;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaContainerType;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import ch.abacus.lib.ui.*;

import javax.swing.*;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.FocusEvent;
import java.awt.*;

public class LizardClassCodeGeneratorViewer extends ProjectToolPanel {
    MetaClass theMetaClass = null;
    JATextField theCodeGenerationName = new JATextField();
    JACheckBox theDefaultListenerBox = new JACheckBox("Use Default Listeners");
    LizardClassListenerTableModel theTableModel = new LizardClassListenerTableModel();
    LizardClassListenerTable theListenerTable = new LizardClassListenerTable(theTableModel);

    JARadioButton btnNone = new JARadioButton("None");
    JARadioButton btnScrollPane = new JARadioButton("Scroll Pane");
    JARadioButton btnPanel = new JARadioButton("Panel");
    JARadioButton btnFrame = new JARadioButton("Frame");
    JARadioButton btnTabbedPane = new JARadioButton("Tabbed Pane");
    JARadioButton btnAbalet = new JARadioButton("Abalet");
    JARadioButton btnButtonGroup = new JARadioButton("Button Group");
    JARadioButton btnTabPage = new JARadioButton("Tab Page");

    class ContainerTypeActionListener implements ActionListener {
        public ContainerTypeActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            JARadioButton theButton = (JARadioButton) evt.getSource();
            if (theButton.equals(btnNone))
                theMetaClass.getMetadata().containerType.setContainerType(MetaContainerType.CONTAINER_NONE);
            else if (theButton.equals(btnScrollPane))
                theMetaClass.getMetadata().containerType.setContainerType(MetaContainerType.CONTAINER_SCROLLPANE);
            else if (theButton.equals(btnPanel))
                theMetaClass.getMetadata().containerType.setContainerType(MetaContainerType.CONTAINER_PANEL);
            else if (theButton.equals(btnFrame))
                theMetaClass.getMetadata().containerType.setContainerType(MetaContainerType.CONTAINER_FRAME);
            else if (theButton.equals(btnTabbedPane))
                theMetaClass.getMetadata().containerType.setContainerType(MetaContainerType.CONTAINER_TABBEDPANE);
            else if (theButton.equals(btnAbalet))
                theMetaClass.getMetadata().containerType.setContainerType(MetaContainerType.CONTAINER_ABALET);
            else if (theButton.equals(btnButtonGroup))
                theMetaClass.getMetadata().containerType.setContainerType(MetaContainerType.CONTAINER_BUTTONGROUP);
            else if (theButton.equals(btnTabPage))
                theMetaClass.getMetadata().containerType.setContainerType(MetaContainerType.CONTAINER_TABPAGE);
        }
    }


    public LizardClassCodeGeneratorViewer(MetaClass objMetaClass, MetadataDispenser theMetadataDispenser) {
        super();
        this.setLocation(100,0);
        this.setSize(400,400);
        Border loweredetched = BorderFactory.createEtchedBorder();
        Border titledDescborder =  new TitledBorder(loweredetched,"Code Generator");
        this.setBorder(titledDescborder);

        theMetaClass = objMetaClass;
        JAScrollPane theScrollPane = new JAScrollPane(theListenerTable);
        theScrollPane.setPreferredSize(new Dimension(350, 160));
        JALabel theLabel = new JALabel("Custom Code Generation");
        theLabel.setHorizontalAlignment(JALabel.CENTER);
        theDefaultListenerBox.setSelected(theMetaClass.getMetadata().bDefaultListeners);
        theCodeGenerationName.setText(theMetaClass.getMetadata().sCustomCodeGenerationMethod);

        add(theDefaultListenerBox, 1, 1, 5, 1);
        add(theScrollPane, 1, 3, 10, 10);
        add(theLabel, 1, 13, 3, 1);
        add(theCodeGenerationName, 1, 14, 12, 1);
        theCodeGenerationName.addFocusListener(new CodeGeneratorSelectorFocusListener());

        JAPanel pnlContainerTypes = new JAPanel(new GridLayout(2, 4));
        ButtonGroup grpContainerTypes = new ButtonGroup();

        pnlContainerTypes.add(btnNone);
        pnlContainerTypes.add(btnScrollPane);
        pnlContainerTypes.add(btnPanel);
        pnlContainerTypes.add(btnFrame);
        pnlContainerTypes.add(btnTabbedPane);
        pnlContainerTypes.add(btnAbalet);
        pnlContainerTypes.add(btnButtonGroup);
        pnlContainerTypes.add(btnTabPage);

        grpContainerTypes.add(btnNone);
        grpContainerTypes.add(btnScrollPane);
        grpContainerTypes.add(btnPanel);
        grpContainerTypes.add(btnFrame);
        grpContainerTypes.add(btnTabbedPane);
        grpContainerTypes.add(btnAbalet);
        grpContainerTypes.add(btnButtonGroup);
        grpContainerTypes.add(btnTabPage);

        ContainerTypeActionListener theActionListener = new ContainerTypeActionListener();
        btnNone.addActionListener(theActionListener);
        btnScrollPane.addActionListener(theActionListener);
        btnPanel.addActionListener(theActionListener);
        btnFrame.addActionListener(theActionListener);
        btnTabbedPane.addActionListener(theActionListener);
        btnAbalet.addActionListener(theActionListener);
        btnButtonGroup.addActionListener(theActionListener);
        btnTabPage.addActionListener(theActionListener);

        JALabel theLabel2 = new JALabel("Container Type");
        add(theLabel2, 1, 15, 3, 1);
        add(pnlContainerTypes, 1, 16, 4, 4);
        theListenerTable.theMetadataDispenser = theMetadataDispenser;
        theListenerTable.Load(objMetaClass);
        MetaContainerType theContainerType = objMetaClass.getMetadata().containerType;
        if (theContainerType.getContainerType() == MetaContainerType.CONTAINER_NONE)
            btnNone.setSelected(true);
        else if (theContainerType.getContainerType() == MetaContainerType.CONTAINER_SCROLLPANE)
            btnScrollPane.setSelected(true);
        else if (theContainerType.getContainerType() == MetaContainerType.CONTAINER_PANEL)
            btnPanel.setSelected(true);
        else if (theContainerType.getContainerType() == MetaContainerType.CONTAINER_FRAME)
            btnFrame.setSelected(true);
        else if (theContainerType.getContainerType() == MetaContainerType.CONTAINER_TABBEDPANE)
            btnTabbedPane.setSelected(true);
        else if (theContainerType.getContainerType() == MetaContainerType.CONTAINER_ABALET)
            btnAbalet.setSelected(true);
        else if (theContainerType.getContainerType() == MetaContainerType.CONTAINER_BUTTONGROUP)
            btnButtonGroup.setSelected(true);
        else if (theContainerType.getContainerType() == MetaContainerType.CONTAINER_TABPAGE)
            btnTabPage.setSelected(true);
    }

    String getCodeGeneratorText() {
        return theCodeGenerationName.getText();
    }

    class CodeGeneratorSelectorFocusListener implements FocusListener {
        public void focusGained(FocusEvent evt) {
        }

        public void focusLost(FocusEvent evt) {
            theMetaClass.getMetadata().sCustomCodeGenerationMethod = theCodeGenerationName.getText();
        }
    }

    class DefaultListenerCheckboxFocusListener implements FocusListener {
        public void focusGained(FocusEvent evt) {
        }

        public void focusLost(FocusEvent evt) {
            theMetaClass.getMetadata().bDefaultListeners = theDefaultListenerBox.isSelected();
        }
    }

}
