/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;

import ch.abacus.lib.ui.renderer.common.*;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class LizardClassMethodViewer extends ProjectToolPanel {
    MetaClass theMetaClass = null;

    LizardMethodComboBoxModel   theMethodComboBoxModel  = new LizardMethodComboBoxModel();
    LizardMethodComboBox        theMethodComboBox       = new LizardMethodComboBox(theMethodComboBoxModel, this);
    KillButtonAction            theKillButtonAction     = new KillButtonAction();
    JAButton                    theDeleteButton         = new JAButton("Delete Method");
    LizardMethodDetailViewer    theMethodDetailTabs;
    JAButton                    theSubmitButton         = new JAButton("Save Method");
    ProjectToolPanelNextButtonAction theNextButtonAction= new ProjectToolPanelNextButtonAction(this);
    MetadataDispenser           theMetadataDispenser;

    class KillButtonAction implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            deleteSelectedMethod();
        }
    }

    public LizardClassMethodViewer(MetaClass objMetaClass, MetadataDispenser theMetadataDispenser) {
        super();
        // Initialization.
        this.setLocation(100,0);
        this.setSize(400,400);

        Border loweredetched = BorderFactory.createEtchedBorder();
        Border titledDescborder =  new TitledBorder(loweredetched,"Methods");
        this.setBorder(titledDescborder);

        theMetaClass = objMetaClass;
        theMethodComboBox.theMetadataDispenser = theMetadataDispenser;
        theMethodDetailTabs = new LizardMethodDetailViewer(theMetaClass, theMetadataDispenser);
        // Layout the viewer.

        add(new JALabel("Method Name"), 1, 1, 3, 1);
        add(theMethodComboBox, 4, 1, 3, 1);
        add(theMethodDetailTabs, 1, 3, 16, 10);
        add(theDeleteButton, 1, 11, 3, 1);
        add(theSubmitButton, 4, 11, 3, 1);

        theMethodComboBox.Load(objMetaClass);
        theDeleteButton.addActionListener(new KillButtonAction());
        theSubmitButton.addActionListener(new ProjectToolPanelNextButtonAction(this));
    }

    public Boolean getExitingComboBox(String sText, Object objLosingFocus) {
        if (sText.trim().length() != 0) {
            // Find if this method already exists.
            MetaMethod match = theMetaClass.getMethod(sText, false);
            // If not, add it.
            if (match == null) {
                Object sConfirmationText = "Do you wish to add the new method '" + sText + "'?";
                String sConfirmationTitle = "New Method";
                int optionType = JOptionPane.YES_NO_OPTION;
                int messageType = JOptionPane.QUESTION_MESSAGE;
                int iChoice = JOptionPane.showConfirmDialog(this, sConfirmationText,
                        sConfirmationTitle, optionType, messageType);
                if (iChoice == 0) { // yes. Add it then.
                    theMethodComboBox.appendItem(sText);
                    return new Boolean(true);
                } else
                    return new Boolean(false);
            }
            return new Boolean(true);
        }
        return new Boolean(true);
    }

    public void selectMethod(MetaMethod oldMethod, MetaMethod newMethod) {
        if (oldMethod != null) {
            oldMethod.setCode(theMethodDetailTabs.theCodeWindow.getText());
            oldMethod.setDoc(theMethodDetailTabs.theDocWindow.getText());
        }
        theMethodDetailTabs.theCodeWindow.setCode(newMethod.getCode());
        theMethodDetailTabs.theDocWindow.setText(newMethod.getDoc());
        theMethodComboBox.setSelectedItem(newMethod.getMethodName());
    }

    public void selectMethod(String sMethodName) {
        MetaMethod newMethod = theMetaClass.getMethod(sMethodName, false);
        selectMethod(null, newMethod);
    }

    public void deleteSelectedMethod() {
        String sMethodName = (String) theMethodComboBox.getSelectedItem();
        theMetaClass.getMetadata().removeMethod(sMethodName);
        Reset();
        theMethodComboBox.Reload(theMetaClass);
        theMethodComboBox.setSelectedItem("");
        theMethodComboBox.resetEditor();
    }

    public void SaveAndClear() {
        MetaMethod theMethod = theMethodComboBox.theMethod;
        if (theMethod != null) {
            theMethod.setCode(theMethodDetailTabs.theCodeWindow.getText());
            theMethod.setDoc(theMethodDetailTabs.theDocWindow.getText());
        }
        theMethodComboBox.theMethod = null;
        Reset();
        theMethodComboBox.Reload(theMetaClass);
        theMethodComboBox.setSelectedItem("");
        theMethodComboBox.resetEditor();
    }


    public void Reset() {
        theMethodDetailTabs.theCodeWindow.setCode("");
        theMethodDetailTabs.theDocWindow.setText("");
        theMethodComboBox.setSelectedItem("");
        theMethodComboBox.resetEditor();
    }
}
