/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;

import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JATextField;
import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;
import ch.abacus.lib.ui.renderer.common.MetaClass;

import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.*;

public class LizardClassNameViewer extends JAPanel {

    JATextField theClassField = new JATextField(20);
    JATextField theSuperClassField = new JATextField(20);
    JATextField theFullPathField = new JATextField(20);
    JATextField theDisplayClassField = new JATextField(20);
    JALabel JALabelX1 = new JALabel("Class:");
    JALabel JALabelX2 = new JALabel("Superclass:");
    JALabel JALabelX3 = new JALabel("Superclass Path:");
    JALabel JALabelX4 = new JALabel("Display:");

    public LizardClassNameViewer(MetaClass theMetaClass) {
        super();
        this.setLocation(100,0);
        this.setSize(400,400);
        Border loweredetched = BorderFactory.createEtchedBorder();
        Border titledDescborder =  new TitledBorder(loweredetched,"Identification");
        this.setBorder(titledDescborder);
        // Initialize the data from the class metadata.
        theClassField.setText(theMetaClass.getMetadata().sClassName);
        theSuperClassField.setText(theMetaClass.getMetadata().getSuperClassName());
        theFullPathField.setText(theMetaClass.getMetadata().getFullPathOfSuperClass());
        theDisplayClassField.setText(theMetaClass.getMetadata().sDisplayClass);

        // Add focus listeners for each of the fields.
        theClassField.addFocusListener(new LizardClassFieldFocusListener(theMetaClass));
        theSuperClassField.addFocusListener(new LizardSuperClassFieldFocusListener(theMetaClass));
        theFullPathField.addFocusListener(new LizardFullPathFieldFocusListener(theMetaClass));
        theDisplayClassField.addFocusListener(new LizardDisplayClassFieldFocusListener(theMetaClass));

        // Add each component to the content pane.
        AnchoringLayoutManager layoutManagertheClassNameViewer = new AnchoringLayoutManager();
        setLayout(layoutManagertheClassNameViewer);
        //  Add the control theClassNameViewer to the Tabbed pane.
        JALabelX1.setLocation(40, 40);
        JALabelX1.setSize(104, 24);
        //  Add the control JALabelX1 to the content pane.
        add(JALabelX1, "JALabelX1");
        layoutManagertheClassNameViewer.setAnchoring(JALabelX1, true, false, true, false);
        theClassField.setLocation(40, 62);
        theClassField.setSize(240, 20);
        //  Add the control theClassField to the content pane.
        add(theClassField, "theClassField");
        layoutManagertheClassNameViewer.setAnchoring(theClassField, false, true, true, false);
        JALabelX2.setLocation(40, 88);
        JALabelX2.setSize(104, 24);
        //  Add the control JALabelX2 to the content pane.
        add(JALabelX2, "JALabelX2");
        layoutManagertheClassNameViewer.setAnchoring(JALabelX2, true, false, true, false);
        theSuperClassField.setLocation(40, 106);
        theSuperClassField.setSize(240, 20);
        //  Add the control theSuperclassField to the content pane.
        add(theSuperClassField, "theSuperClassField");
        layoutManagertheClassNameViewer.setAnchoring(theSuperClassField, false, true, true, false);
        JALabelX3.setLocation(40, 136);
        JALabelX3.setSize(104, 24);
        //  Add the control JALabelX3 to the content pane.
        add(JALabelX3, "JALabelX3");
        layoutManagertheClassNameViewer.setAnchoring(JALabelX3, true, false, true, false);
        theFullPathField.setLocation(40, 158);
        theFullPathField.setSize(240, 20);
        //  Add the control theFullPathField to the content pane.
        add(theFullPathField, "theFullPathField");
        layoutManagertheClassNameViewer.setAnchoring(theFullPathField, false, true, true, false);
        theDisplayClassField.setLocation(40, 206);
        theDisplayClassField.setSize(240, 20);
        //  Add the control theDisplayClassField to the content pane.
        add(theDisplayClassField, "theDisplayClassField");
        layoutManagertheClassNameViewer.setAnchoring(theDisplayClassField, false, true, true, false);
        JALabelX4.setLocation(40, 184);
        JALabelX4.setSize(104, 24);
        //  Add the control JALabelX4 to the content pane.
        add(JALabelX4, "JALabelX4");
        layoutManagertheClassNameViewer.setAnchoring(JALabelX4, true, false, true, false);
    }
}
