/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;

import javax.swing.*;
import java.lang.reflect.*;
import javax.swing.border.*;
import javax.swing.plaf.basic.*;
import javax.swing.plaf.metal.*;
import java.awt.event.*;
import javax.swing.plaf.metal.*;
import java.awt.*;

import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;




public class LizardComboBox extends JComboBox {
    MetaClass theMetaClass = null;
    public MetadataDispenser theMetadataDispenser = null;
    public Object theReceiver = null;
    public ComboBoxModel theModel = null;
    ComboBoxEditor theComboBoxEditor = null;
    String sStoredValue = null;

    public LizardComboBox(ComboBoxModel objModel, Object objReceiver) {
        super(objModel);
        setEditable(true);
        theModel = objModel;
        theReceiver = objReceiver;
        // Change editor to one of ours.
        ComboBoxEditor theEditor = getEditor();
//      if (theEditor!=null) {
//          JATextField theEditField = (JATextField) theEditor.getEditorComponent();
//          theEditField.addFocusListener(new LizardGeneralComboBoxEditorComponentFocusListener(this));
//      }
///          theEditor.addActionListener(new ClassEditComboBoxActionListener(this, objReceiver));
        if (theEditor instanceof MetalComboBoxEditor) {
            theComboBoxEditor = new LizardMetalComboBoxEditor(objReceiver);
            setEditor(theComboBoxEditor);
        } else {
            if (theEditor instanceof BasicComboBoxEditor) {
                theComboBoxEditor = new LizardBasicComboBoxEditor(objReceiver);
                setEditor(theComboBoxEditor);
            } else {
                if (theEditor != null) {
                    System.out.println("Don't know this combo! " + theEditor.getClass().getName());
                    theComboBoxEditor = getEditor();
                } else {
                    System.out.println("Cannot find editor for combobox");
                    setEditable(false);
                    theComboBoxEditor = null;
                }
            }
        }

    }

    public void setEditorText(String sValue) {
        ComboBoxEditor theEditor = getEditor();
        JTextField theEditField = (JTextField) theEditor.getEditorComponent();
        theEditField.setText(sValue);
    }

    public void SelectAllText() {
        ComboBoxEditor theEditor = getEditor();
        JATextArea theEditField = (JATextArea) theEditor.getEditorComponent();
        theEditField.selectAll();
    }

    public void resetEditor() {
        configureEditor(getEditor(), "");
    }

    public static void registerComboFocusListener(JAComboBox box, FocusListener listener, String name) {
        Component editor = box.getEditor().getEditorComponent();
        editor.setName(name);
        editor.addFocusListener(listener);
        LookAndFeel currentLAF = null;
        if ((currentLAF = UIManager.getLookAndFeel()) != null) {
            if (currentLAF.getID().equals("Metal")) {
                Component[] comboComponents = box.getComponents();
                for (int i = 0; i < comboComponents.length; i++) {
                    if (comboComponents[i] instanceof MetalComboBoxButton) {
                        comboComponents[i].addFocusListener(listener);
                        comboComponents[i].setName(name);
                        return;
                    }
                }
            }
            box.setName(name);
            box.addFocusListener(listener);
        }
    }

}
