/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.reflect.Method;

public class LizardResetFocusListener extends FocusAdapter {
    Object theReceiver = null;

    public LizardResetFocusListener(Object objReceiver) {
        super();
        theReceiver = objReceiver;
    }

    public void focusLost(FocusEvent evt) {
        try {
            Class clsReceiver = theReceiver.getClass();
            Class[] clsParams = null;
            Method m = clsReceiver.getMethod("SaveAndClear", clsParams);
            Object[] objArgList = null;
            m.invoke(theReceiver, objArgList);
        } catch (NoSuchMethodException e1) {
            System.out.println("Reset Tab: Bad Receiver!");
        } catch (java.lang.reflect.InvocationTargetException e2) {
            System.out.println("Reset Tab: Bad Target Receiver!");
        } catch (IllegalAccessException e3) {
            System.out.println("Reset Tab: Illegal Access!");
        }
    }
}
