/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;

import ch.abacus.lib.ui.JAComboBox;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;

public class LizardTypeComboBox extends JAComboBox {
    MetadataDispenser theMetadataDispenser;

    public LizardTypeComboBox(MetadataDispenser objProject) {
        super();
        theMetadataDispenser = objProject;
        // Get data for the class...
        addItem("boolean");
        addItem("char");
        addItem("byte");
        addItem("short");
        addItem("int");
        addItem("long");
        addItem("float");
        addItem("double");
        addItem("String");
        addItem("Integer");
        addItem("Boolean");
        addItem("Date");
        addItem("Float");
        Load();
    }

    void addChildren(MetaClass theClass) {
        while (theClass != null) {
            addItem(theClass.getMetadata().sClassName);
            if (theClass.getFirstClass() != null)
                addChildren(theClass.getFirstClass());
            theClass = theClass.getNextSibling();
        }
    }

    void Load() {
        // add classes.
        MetaClass theClass = theMetadataDispenser.getFirstClass();
        while (theClass != null) {
            addItem(theClass.getMetadata().sClassName);
            // Clear the pointer to next to not have crossed references.
            // We use designclass tree to get to classes here, not metadata.
            String sFullPathOfSuper = theClass.getMetadata().getFullPathOfSuperClass();
            if ((sFullPathOfSuper != null) && (sFullPathOfSuper.trim().length() != 0))
                addItem(sFullPathOfSuper);
            if (theClass.getFirstClass() != null)
                addChildren(theClass.getFirstClass());
            theClass = theClass.getNextSibling();
        }
    }
}
