/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaObject;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Dec 2, 2004
 * Time: 1:03:59 PM<P>
 * All Property Helpers need to be derived from this class<p>
 * Implement the execute() method to create and display the helper
 * @see #execute
 */
public abstract class AbstractPropertyHelper {
    /**
     * The execute method is called by the DC when it needs to display a helper for a property
     * @param metaObject the MetaObject being edited
     * @param sPropertyName the name of the property being edited
     * @param superDesignCockpit the SuperDesignCockpit instance
     * @return true, if the helper modified data; false otherwise.
     */
    public abstract boolean execute (MetaObject metaObject, String sPropertyName, SuperDesignCockpit superDesignCockpit);
}
