/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.customizer.CustomizerDataConnectionInterface;
import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.util.GlobalInterface;

public class CustomizerDesignCockpit extends SuperDesignCockpit {

    public CustomizerDesignCockpit (
            String sPreferences,
            GlobalInterface globalInterface,
            CustomizerDataConnectionInterface dataConnection)
            throws HammerException
    {
        super(false);

        setSystemConfigurationPathName("ch.abacus.lib.ui.renderer.deploy.");
        setSystemConfigurationDocumentName("hammer-configuration.xml");
        setSystemMetadataDocumentName("customizer-metadata.meta");

        theCustomizer = new IDECustomizer(this, dataConnection);

        bStartedFromExternalProgram = true;

        defineInitialFrameListeners();

        init(sPreferences, globalInterface);
    }

}
