/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import javax.swing.text.JTextComponent;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyListener;

/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

class CommonEditFocusAdapter extends FocusAdapter {
    public PropertyTable thePropertyTable;
    public CommonEditFocusAdapter(PropertyTable thePropertyTable) {
        super();
        this.thePropertyTable = thePropertyTable;
    }
}

public class IDECommonEditFocusAdapter {
    public static FocusAdapter selectAllAdapter;

    public static void setSelectAllOnEdit(JTextComponent theComponent, PropertyTable thePropertyTable) {
        if (selectAllAdapter == null) {
            selectAllAdapter = new CommonEditFocusAdapter(thePropertyTable) {
                public void focusGained(java.awt.event.FocusEvent evt) {
                    JTextComponent theComponent = (JTextComponent) evt.getSource();
                    theComponent.selectAll();
//                    KeyListener[] theKeyListeners = theComponent.getKeyListeners();
//                    for (int i=0; i<theKeyListeners.length; i++) {
//                        theComponent.removeKeyListener(theKeyListeners[i]);
//                    }
//                    theComponent.addKeyListener(new PropertyTableKeyListener(thePropertyTable));
                }
            };
        }
        theComponent.addFocusListener(selectAllAdapter);
    }
}
