/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaObject;

import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: May 6, 2003
 * Time: 9:57:39 AM
 * To change this template use Options | File Templates.
 */
public class IDEMethodListSelectionListener implements ListSelectionListener {
    IDEMethodList theMethodList = null;
    public String sMethodNameSelected = null;
    MetaObject theSavedObject = null;

    public IDEMethodListSelectionListener(IDEMethodList objMethodList) {
        theMethodList = objMethodList;
    }

    public void valueChanged(ListSelectionEvent evt) {
//        theSavedObject.theDesignProject.setProjectChangedState(true);
        if (theSavedObject == null)
            theSavedObject = theMethodList.theLastObjectLoaded;
        else {  // If the object is changing, prepare to save the method code.
            if (theSavedObject != theMethodList.theLastObjectLoaded) {
                theSavedObject = theMethodList.theLastObjectLoaded;
                String sMethodName = (String) theMethodList.getSelectedValue();
                if ((sMethodNameSelected != null) && (!sMethodNameSelected.equals(sMethodName))) {
                    if (theMethodList.theSourceEditor.getText().trim().length() != 0) {
                        theMethodList.save(sMethodNameSelected);
                    }
                }
            } else {
                IDESourceEditor theEditor = theMethodList.theSourceEditor;

                // Don't allow complete erasures.
                if (sMethodNameSelected != null) {
                    if (theEditor.getText().trim().length() != 0) {
                        theMethodList.save(sMethodNameSelected, theEditor.getText());
                    }
                }
            }
        }
        theMethodList.showCurrentMethod();
        sMethodNameSelected = (String) theMethodList.getSelectedValue();
    }

}
