/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;


import ch.abacus.lib.ui.renderer.common.MetaObject;

import java.awt.*;
import java.util.ArrayList;

/**
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: Aug 17, 2003
 * Time: 4:02:24 PM
 * To change this template use Options | File Templates.
 */
public class IDEMultiSelectCommandProcessor {
    public static final int NOP = 0;
    public static final int ALIGN_HORZ_NO_CHANGE = 0;
    public static final int ALIGN_HORZ_LEFT = 1;
    public static final int ALIGN_HORZ_CENTERS = 2;
    public static final int ALIGN_HORZ_RIGHT = 4;
    public static final int ALIGN_HORZ_EQUAL = 8;
    public static final int ALIGN_HORZ_CENTER_IN_WINDOW = 16;
    public static final int ALIGN_HORZ_MASK = 0xff;
    public static final int ALIGN_VERT_NO_CHANGE = 0;
    public static final int ALIGN_VERT_TOP = 256;
    public static final int ALIGN_VERT_CENTERS = 512;
    public static final int ALIGN_VERT_BOTTOM = 1024;
    public static final int ALIGN_VERT_EQUAL = 2048;
    public static final int ALIGN_VERT_CENTER_IN_WINDOW = 4096;
    public static final int ALIGN_VERT_MASK = 0xff00;
    public static final int SIZE_HORZ_NO_CHANGE = 0;
    public static final int SIZE_HORZ_SHRINK = 0x10000;
    public static final int SIZE_HORZ_GROW = 0x20000;
    public static final int SIZE_HORZ_SET = 0x40000;
    public static final int SIZE_HORZ_MASK = 0xff0000;
    public static final int SIZE_VERT_NO_CHANGE = 0;
    public static final int SIZE_VERT_SHRINK = 0x1000000;
    public static final int SIZE_VERT_GROW = 0x2000000;
    public static final int SIZE_VERT_SET = 0x4000000;
    public static final int SIZE_VERT_MASK = 0xff000000;
    int horzSet = 0;
    int vertSet = 0;
    int Command = IDEMultiSelectCommandProcessor.NOP;
    SuperDesignCockpit theCockpit;
    public IDEMultiSelectCommandProcessor(SuperDesignCockpit theCockpit, int Command) {
        this.theCockpit = theCockpit;
        this.Command = Command;
    }

    boolean doCommand() {
        int iObjectCount = theCockpit.theCurrentDesignProject.getSelectedObjectCount();
        int left[] = new int[iObjectCount];
        int right[] = new int[iObjectCount];
        int top[] = new int[iObjectCount];
        int bottom[] = new int[iObjectCount];
        int height[] = new int[iObjectCount];
        int width[] = new int[iObjectCount];
        ArrayList objects = new ArrayList();
        // skip the selected frame.
        int iObject = 0;
        for (int i=0; i<iObjectCount; i++) {
            MetaObject theObject = theCockpit.theCurrentDesignProject.getSelectedObject(i);
            if ((theObject.isFrame()==false) && (theObject.isAbalet()==false)) {
                left[iObject] = theObject.getLocation().x;
                width[iObject] = theObject.getSize().width;
                right[iObject] = left[iObject] + width[iObject] - 1;
                top[iObject] = theObject.getLocation().y;
                height[iObject] = theObject.getSize().height;
                bottom[iObject] = top[iObject] + height[iObject] - 1;
                objects.add(theObject);
                iObject++;
            }
        }
        iObjectCount = iObject;
        // alignment first
        // horz
        if ((Command & ALIGN_HORZ_MASK) != 0) {
            int SubCommand = Command & ALIGN_HORZ_MASK;
            switch (SubCommand) {
               case ALIGN_HORZ_LEFT: {
                   int iLeft = left[0];
                   for (int i=1; i<iObjectCount; i++) {
                       left[i] = iLeft;
                       right[i] = iLeft + width[i];
                   }
               }
               break;
               case ALIGN_HORZ_CENTERS:  {
                   int iAvgCenter = 0;
                   for (int i=0; i<iObjectCount; i++) {
                       iAvgCenter += (left[i] + width[i]/2);
                   }
                   iAvgCenter /= iObjectCount;
                   for (int i=0; i<iObjectCount; i++) {
                       left[i] = iAvgCenter - width[i]/2;
                       right[i] = left[i] + width[i];
                   }
               }
               break;
               case ALIGN_HORZ_RIGHT:  {
                   int iRight = right[0];
                   for (int i=1; i<iObjectCount; i++) {
                       right[i] = iRight;
                       left[i] = iRight - width[i];
                   }
               }
               break;
               case ALIGN_HORZ_EQUAL:  {
                   // sort first
                   int[] spaces = new int[iObjectCount];
                   int[] sorted = new int[iObjectCount];
                   for (int j=0; j<iObjectCount; j++)
                        sorted[j] = j;
                   for (int j=1; j<iObjectCount; j++) {
                       for (int i=iObjectCount-1; i >= j; i--) {
                           int obj1 = sorted[i-1];
                           int obj2 = sorted[i];
                           if (left[obj1]>left[obj2]) {
                               int iExchange = sorted[i-1];
                               sorted[i-1] = sorted[i];
                               sorted[i] = iExchange;
                           }
                       }
                   }
                   // get space between
                   int avgSpace = 0;
                   for (int i=0; i<iObjectCount; i++) {
                       int ref = sorted[i];
                       spaces[ref] = 0;
                       if (i > 0) {
                           int prev = sorted[i-1];
                           spaces[ref] = left[ref] - right[prev];
                           avgSpace += spaces[ref];
                       }
                   }
                   // calculate avg space
                   avgSpace /= (iObjectCount-1);
                   // apply space from leftmost to right most.
                   for (int i=1; i<iObjectCount; i++) {
                       int ref = sorted[i];
                       int prev = sorted[i-1];
                       left[ref] = right[prev] + avgSpace;
                       right[ref] = left[ref] + width[ref];
                   }
               }
               break;
               case ALIGN_HORZ_CENTER_IN_WINDOW:  {
                   for (int i=0; i<iObjectCount; i++) {
                       MetaObject theMetaObject = ((MetaObject)objects.get(i));
                       MetaObject theParentObject = theMetaObject.theParentObject;
                       Dimension dimParent = theParentObject.getSize();
                       left[i] = dimParent.width/2 - width[i]/2;
                       right[i] = left[i] + width[i];
                   }
               }
               break;
            }
        }
        // vert
        if ((Command & ALIGN_VERT_MASK) != 0) {
            int SubCommand = Command & ALIGN_VERT_MASK;
            switch (SubCommand) {
               case ALIGN_VERT_TOP: {
                   int iTop = top[0];
                   for (int i=1; i<iObjectCount; i++) {
                       top[i] = iTop;
                       bottom[i] = iTop + height[i];
                   }
               }
               break;
               case ALIGN_VERT_CENTERS:  {
                   int iAvgCenter = 0;
                   for (int i=0; i<iObjectCount; i++) {
                       iAvgCenter += (top[i] + height[i]/2);
                   }
                   iAvgCenter /= iObjectCount;
                   for (int i=0; i<iObjectCount; i++) {
                       top[i] = iAvgCenter - height[i]/2;
                       bottom[i] = top[i] + height[i];
                   }
               }
               break;
               case ALIGN_VERT_BOTTOM:  {
                   int iBottom = bottom[0];
                   for (int i=1; i<iObjectCount; i++) {
                       bottom[i] = iBottom;
                       top[i] = iBottom - height[i];
                   }
               }
               break;
               case ALIGN_VERT_EQUAL:  {
                   // sort first
                   int[] spaces = new int[iObjectCount];
                   int[] sorted = new int[iObjectCount];
                   for (int j=0; j<iObjectCount; j++)
                        sorted[j] = j;
                   for (int j=1; j<iObjectCount; j++) {
                       for (int i=iObjectCount-1; i >= j; i--) {
                           int obj1 = sorted[i-1];
                           int obj2 = sorted[i];
                           if (top[obj1]>top[obj2]) {
                               int iExchange = sorted[i-1];
                               sorted[i-1] = sorted[i];
                               sorted[i] = iExchange;
                           }
                       }
                   }
                   // get space between
                   int avgSpace = 0;
                   for (int i=0; i<iObjectCount; i++) {
                       int ref = sorted[i];
                       spaces[ref] = 0;
                       if (i > 0) {
                           int prev = sorted[i-1];
                           spaces[ref] = top[ref] - bottom[prev];
                           avgSpace += spaces[ref];
                       }
                   }
                   // calculate avg space
                   avgSpace /= (iObjectCount-1);
                   // apply space from leftmost to right most.
                   for (int i=1; i<iObjectCount; i++) {
                       int ref = sorted[i];
                       int prev = sorted[i-1];
                       top[ref] = bottom[prev] + avgSpace;
                       bottom[ref] = top[ref] + height[ref];
                   }
               }
               break;
               case ALIGN_VERT_CENTER_IN_WINDOW:  {
                   for (int i=0; i<iObjectCount; i++) {
                       MetaObject theMetaObject = ((MetaObject)objects.get(i));
                       MetaObject theParentObject = theMetaObject.theParentObject;
                       Dimension dimParent = theParentObject.getSize();
                       top[i] = dimParent.height/2 - height[i]/2;
                       bottom[i] = top[i] + height[i];
                   }
               }
               break;
            }
        }
        if (((Command & ALIGN_VERT_MASK) != 0) || ((Command & ALIGN_HORZ_MASK) != 0)) {
            for (int i=0; i<iObjectCount; i++) {
                MetaObject theMetaObject = ((MetaObject)objects.get(i));
                theMetaObject.bAnchoringOff = true;
                theMetaObject.setLocation(left[i], top[i]);
                theCockpit.theSizeboxes.update(theMetaObject, theMetaObject.iXLocation, theMetaObject.iYLocation,
                        (int) theMetaObject.dimSize.getWidth(), (int) theMetaObject.dimSize.getHeight());
            }
            return true;
        }
        // now size
        // horz
        if ((Command & SIZE_HORZ_MASK) != 0) {
            int SubCommand = Command & SIZE_HORZ_MASK;
            switch (SubCommand) {
               case SIZE_HORZ_SHRINK: {
                   int iSmallest = width[0];
                   for (int i=1; i<iObjectCount; i++) {
                       if (iSmallest > width[i])
                           iSmallest = width[i];
                   }
                   for (int i=0; i<iObjectCount; i++) {
                       width[i] = iSmallest;
                       right[i] = left[i] + iSmallest;
                   }
               }
               break;
               case SIZE_HORZ_GROW:  {
                   int iWidest = width[0];
                   for (int i=1; i<iObjectCount; i++) {
                       if (iWidest < width[i])
                           iWidest = width[i];
                   }
                   for (int i=0; i<iObjectCount; i++) {
                       width[i] = iWidest;
                       right[i] = left[i] + iWidest;
                   }
               }
               break;
               case SIZE_HORZ_SET:  {
                   for (int i=0; i<iObjectCount; i++) {
                       width[i] = horzSet;
                       right[i] = left[i] + horzSet;
                   }
               }
               break;
            }

        }
        // vert
        if ((Command & SIZE_VERT_MASK) != 0) {
            int SubCommand = Command & SIZE_VERT_MASK;
            switch (SubCommand) {
               case SIZE_VERT_SHRINK: {
                   int iShortest = height[0];
                   for (int i=1; i<iObjectCount; i++) {
                       if (iShortest > height[i])
                           iShortest = height[i];
                   }
                   for (int i=0; i<iObjectCount; i++) {
                       height[i] = iShortest;
                       bottom[i] = top[i] + iShortest;
                   }
               }
               break;
               case SIZE_VERT_GROW:  {
                   int iTallest = height[0];
                   for (int i=1; i<iObjectCount; i++) {
                       if (iTallest < height[i])
                           iTallest = height[i];
                   }
                   for (int i=0; i<iObjectCount; i++) {
                       height[i] = iTallest;
                       bottom[i] = top[i] + iTallest;
                   }
               }
               break;
               case SIZE_VERT_SET:  {
                   for (int i=0; i<iObjectCount; i++) {
                       height[i] = vertSet;
                       bottom[i] = top[i] + vertSet;
                   }
               }
               break;
            }
        }
        if (((Command & SIZE_VERT_MASK) != 0) || ((Command & SIZE_HORZ_MASK) != 0)) {
            for (int i=0; i<iObjectCount; i++) {
                MetaObject theMetaObject = ((MetaObject)objects.get(i));
                theMetaObject.bAnchoringOff = true;
                theMetaObject.setSize(width[i], height[i]);
                theCockpit.theSizeboxes.update(theMetaObject, theMetaObject.iXLocation, theMetaObject.iYLocation,
                        (int) theMetaObject.dimSize.getWidth(), (int) theMetaObject.dimSize.getHeight());
            }
            return true;
        }
        return false;
    }
}
