/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.*;
import ch.abacus.lib.ui.JAScrollingPanel;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: May 5, 2003
 * Time: 9:33:38 PM
 * To change this template use Options | File Templates.
 */

public class IDEObjectPopupMenu extends JPopupMenu {
    public MetaObject theTarget = null;
    JMenuItem copySelectedObjectItem, cutSelectedObjectItem, deleteSelectedObjectItem, pasteSelectedObjectItem;
    //JMenuItem helpItem;
    JMenuItem foregroundColorItem, backgroundColorItem, fontItem;
    JMenuItem classSpecificItem;
    JMenu addPaneMenu;
    JMenu copyObjectMenu;
    JMenu addJMenuMenu;
    JMenu addJMenuItemMenu;
    JMenuItem addJMenuSeparator;
    JMenuItem scrollingPanelItem;
    JMenu addJToolBarComponents;

    IDEMultiSelectMenu multiSelectMenu;

    AbstractAction copySelectedObjectAction;
    AbstractAction copySelectedObjectActionNested;
    AbstractAction copySelectedObjectActionWithoutCode;
    CutSelectedObjectAction cutSelectedObjectAction;
    AbstractAction deleteSelectedObjectAction;
    AbstractAction classSpecificAction;
    ExpandContractAction expandContractAction;
    //HelpAction helpAction;
    SuperDesignCockpit theDesignCockpit = null;
    public Point ptLastPopupLocation = new Point(0, 0);
    public Point ptActualStrikePoint = new Point(0, 0);
    private JMenuItem expandContractItem;
    private JMenuItem splitVerticalItem;
    private JMenuItem splitHorizontalItem;
    AbstractAction splitVerticalAction;
    AbstractAction splitHorizontalAction;

    public IDEObjectPopupMenu(SuperDesignCockpit objDesignCockpit) {
        super();
        theDesignCockpit = objDesignCockpit;
        if (theDesignCockpit.theProgramMode == SuperDesignCockpit.JAVABUILDER) {
            copySelectedObjectActionNested = theDesignCockpit.theActionManager.createCopySelectedObjectAction("Full Copy (Object and Child Objects - with code)", theDesignCockpit, 0);
            copySelectedObjectAction = theDesignCockpit.theActionManager.createCopySelectedObjectAction("Copy Object (with code)", theDesignCockpit, 1);
            copySelectedObjectActionWithoutCode = theDesignCockpit.theActionManager.createCopySelectedObjectAction("Copy Object (without code)", theDesignCockpit, 2);
            copyObjectMenu = new JMenu("Copy Object");
            copyObjectMenu.add(new JMenuItem(copySelectedObjectActionNested));
            copyObjectMenu.add(new JMenuItem(copySelectedObjectAction));
            copyObjectMenu.add(new JMenuItem(copySelectedObjectActionWithoutCode));
        } else {
            String sLabel = theDesignCockpit.theActionManager.getCopyAction().getLabel();
            copySelectedObjectAction = theDesignCockpit.theActionManager.createCopySelectedObjectAction(sLabel, theDesignCockpit, 0);
            copySelectedObjectItem = new JMenuItem(copySelectedObjectAction);
            copySelectedObjectItem.setMnemonic(theDesignCockpit.theActionManager.getCopyAction().getMnemonicKey());
        }

        String sLabel = theDesignCockpit.theActionManager.getCutAction().getLabel();
        cutSelectedObjectAction = new CutSelectedObjectAction(sLabel, theDesignCockpit.cutIcon, theDesignCockpit);

        deleteSelectedObjectAction = theDesignCockpit.theActionManager.getDeleteAction();

        classSpecificAction = theDesignCockpit.theActionManager.getClassEditorAction();
        expandContractAction = new ExpandContractAction(theDesignCockpit);

        splitVerticalAction = theDesignCockpit.theActionManager.getInsertVertSplitterAction();
        splitHorizontalAction = theDesignCockpit.theActionManager.getInsertHorzSplitterAction();

        //helpAction = new HelpAction("Help", theDesignCockpit.helpIcon, theDesignCockpit);
        scrollingPanelItem = new JMenuItem(expandContractAction);
        //helpItem = new JMenuItem(helpAction);
        cutSelectedObjectItem = new JMenuItem(cutSelectedObjectAction);
        cutSelectedObjectItem.setMnemonic(theDesignCockpit.theActionManager.getCutAction().getMnemonicKey());
        pasteSelectedObjectItem = new JMenuItem(theDesignCockpit.theActionManager.getPasteSelectedObjectAction());
        deleteSelectedObjectItem = new JMenuItem(deleteSelectedObjectAction);
        if (theDesignCockpit.theActionManager.getForegroundColorChooserAction() != null)
            foregroundColorItem = new JMenuItem(theDesignCockpit.theActionManager.getForegroundColorChooserAction());
        if (theDesignCockpit.theActionManager.getBackgroundColorChooserAction() != null)
            backgroundColorItem = new JMenuItem(theDesignCockpit.theActionManager.getBackgroundColorChooserAction());
        classSpecificItem = new JMenuItem(classSpecificAction);
        expandContractItem = new JMenuItem(expandContractAction);
        splitVerticalItem = new JMenuItem(splitVerticalAction);
        splitHorizontalItem = new JMenuItem(splitHorizontalAction);
        addPaneMenu = new JMenu(theDesignCockpit.theLanguageManager.getMessage("ContextMenu.AddPane.label", "Add Pane"));
        if (theDesignCockpit.theActionManager.getFontChooserAction() != null)
            fontItem = new JMenuItem(theDesignCockpit.theActionManager.getFontChooserAction());
        multiSelectMenu = new IDEMultiSelectMenu(this.theDesignCockpit);

        addJMenuMenu = new JMenu("Add Menu");
        addJMenuItemMenu = new JMenu("Add MenuItem");
        addJMenuSeparator = new JMenu("Add Separator");
        addJToolBarComponents = new JMenu("Add Components");
    }



    public Point getLastPopupLocation() {
        return ptLastPopupLocation;
    }

    public Point getActualStrikePoint() {
        return this.ptActualStrikePoint;
    }

    public void addTabPageClasses(JMenu theAddPaneMenu, MetaClass theClass, MetaObject theObject) {
        while (theClass != null) {
            if (theClass.getFirstClass() != null)
                addTabPageClasses(theAddPaneMenu, theClass.getFirstClass(), theObject);
            if (theClass.getMetadata().containerType.getContainerType() == MetaContainerType.CONTAINER_TABPAGE) {
                // First search if the class has already been added.
                String sItemText = (theDesignCockpit.theLanguageManager.expandMessage("ContextMenu.AddPane.Add.label", "Add {0}", theClass.getMetadata().sClassName));
                AddPaneAction theAction = new AddPaneAction(sItemText, theClass.getMetadata().sClassName, theDesignCockpit);
                JMenuItem theItem = new JMenuItem(theAction);
                theAddPaneMenu.add(theItem);
            }
            theClass = theClass.getNextSibling();
        }
    }

    public void addJMenuClasses(JMenu theAddJMenuBarMenu, MetaClass theClass, MetaObject theObject) {
        while (theClass != null) {
            if (theClass.getFirstClass() != null)
                addJMenuClasses(theAddJMenuBarMenu, theClass.getFirstClass(), theObject);
            if (theClass.getMetadata().containerType.getContainerType() == MetaContainerType.CONTAINER_JMENU) {
                // First search if the class has already been added.
                String sItemText = "Add " + theClass.getMetadata().sClassName;
                AddJMenuAction theAction = new AddJMenuAction(sItemText, theClass.getMetadata().sClassName, theDesignCockpit);
                JMenuItem theItem = new JMenuItem(theAction);
                theAddJMenuBarMenu.add(theItem);
            }
            theClass = theClass.getNextSibling();
        }
    }

    public void addJToolBarClasses(JMenu theAddJToolBar, MetaClass theClass, MetaObject theObject) {
        while (theClass != null) {
            if (theClass.getFirstClass() != null)
                addJToolBarClasses(theAddJToolBar, theClass.getFirstClass(), theObject);
            if ((theClass.getMetadata().sClassName.equalsIgnoreCase("JToolBarButton"))){
                String sItemText = "Add " + theClass.getMetadata().sClassName;
                AddJToolBarAction theAction = new AddJToolBarAction(sItemText, theClass.getMetadata().sClassName, theDesignCockpit);
                JMenuItem theItem = new JMenuItem(theAction);
                theAddJToolBar.add(theItem);
            }
            theClass = theClass.getNextSibling();
        }
    }

    public void addJItemMenuClasses(JMenuItem theAddJMenuMenu, MetaClass theClass, MetaObject theObject) {
        while (theClass != null) {
            if (theClass.getFirstClass() != null)
                addJItemMenuClasses(theAddJMenuMenu, theClass.getFirstClass(), theObject);
            if (theClass.getMetadata().containerType.getContainerType() == MetaContainerType.CONTAINER_JMENUITEM) {
                // First search if the class has already been added.
                String sItemText = "Add " + theClass.getMetadata().sClassName;
                AddJMenuAction theAction = new AddJMenuAction(sItemText, theClass.getMetadata().sClassName, theDesignCockpit);
                JMenuItem theItem = new JMenuItem(theAction);
                theAddJMenuMenu.add(theItem);
            }
            else if (theClass.getMetadata().sClassName.equalsIgnoreCase("JSeparator")) {
                String sItemText = "Add " + theClass.getMetadata().sClassName;
                AddJMenuAction theAction = new AddJMenuAction(sItemText, theClass.getMetadata().sClassName, theDesignCockpit);
                JMenuItem theItem = new JMenuItem(theAction);
                theAddJMenuMenu.add(theItem);
            }
            theClass = theClass.getNextSibling();
        }
    }
    public void show(Component thePlaceToDisplay, int x, int y, MetaObject theTarget) {
        MetaObject theObject = theTarget;
        this.theTarget = theTarget;

        removeAll();

        if ((theObject != null)  && (theObject.theVisualObject != null) &&
                 (theObject.theVisualObject instanceof JAScrollingPanel)) {
                    expandContractItem.setText(((JAScrollingPanel)theObject.theVisualObject).getExpansionState() ? "Reduce" : "Expand");
                    insert(expandContractItem, 0);
        }
        if (theObject != null)  {
            if (theObject.isFrame() || theObject.isTabPage() || theObject.isPanel()) {
                insert(splitVerticalItem, 0);
                insert(splitHorizontalItem, 0);
            }
        }

        if ((theObject != null) && (theObject.isTabbedPane())) {
            JMenuItem itemTabControlEditor = new JMenuItem(new AddTabControlEditorActionAction(theDesignCockpit));
            insert(itemTabControlEditor, 0);
            insert(addPaneMenu, 0);
            addPaneMenu.removeAll();
            MetaClass theClass = theDesignCockpit.theCurrentDesignProject.theMetaProject.getFirstClass();
            addTabPageClasses(addPaneMenu, theClass, theObject);
        }
        else if ((theObject != null) && (theObject.isJMenuBar())) {
            insert(addJMenuMenu, 0);
            addJMenuMenu.removeAll();
            MetaClass theClass = theDesignCockpit.theCurrentDesignProject.theMetaProject.getFirstClass();
            addJMenuClasses(addJMenuMenu, theClass, theObject);
        }
        else if ((theObject != null) && (theObject.isJMenu())) {
            insert(addJMenuItemMenu, 0);
            addJMenuItemMenu.removeAll();
            MetaClass theClass = theDesignCockpit.theCurrentDesignProject.theMetaProject.getFirstClass();
            addJItemMenuClasses(addJMenuItemMenu, theClass, theObject);
        }
        else if ((theObject != null) && (theObject.isJToolBar())) {
            insert(addJToolBarComponents, 0);
            addJToolBarComponents.removeAll();
            MetaClass theClass = theDesignCockpit.theCurrentDesignProject.theMetaProject.getFirstClass();
            addJToolBarClasses(addJToolBarComponents, theClass, theObject);
        }


        if (theObject != null) {
            if (theObject.theClass.getMetadata().theDesignEditor != null)
                insert(classSpecificItem, 0);
        }

        addSeparator();

        add(cutSelectedObjectItem);
        if (theDesignCockpit.theProgramMode == SuperDesignCockpit.JAVABUILDER)
            add(copyObjectMenu);
        else
            add(copySelectedObjectItem);

        add(pasteSelectedObjectItem);

        add(deleteSelectedObjectItem);

        addSeparator();

        if (this.theDesignCockpit.theCurrentDesignProject.getSelectedObjectCount() > 1) {
            add(multiSelectMenu);
        }
        else {
            if (foregroundColorItem != null)
                add(foregroundColorItem);
            if(backgroundColorItem != null)
                add(backgroundColorItem);
            if(fontItem != null)
                add(fontItem);
        }

        //addSeparator();
        //add(helpItem);

        // See if the Customizer wants to add any items...
        if (theDesignCockpit.isCustomizing()) {
            theDesignCockpit.theCustomizer.addToContextMenu(this, theTarget);
        }

        // It is possible that the menu could have a separator as its last item
        // We will remove this, as it looks untidy...
        int lastComponentIndex = getComponentCount()-1;
        Component component = getComponent(lastComponentIndex);
        if (component instanceof JSeparator)
            remove(lastComponentIndex);

        super.show(thePlaceToDisplay, x, y);
    }

    class AddJMenuAction extends AbstractAction {
        SuperDesignCockpit theDesignCockpit = null;
        String sClassName = null;
        IDEObjectPopupMenu theMenu;

        public AddJMenuAction(String label, Icon icon, String theClassName, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            sClassName = theClassName;
            theDesignCockpit = objDesignCockpit;
        }

        public AddJMenuAction(String label, String theClassName, SuperDesignCockpit objDesignCockpit) {
            super(label);
            sClassName = theClassName;
            theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            theDesignCockpit.SelectObject(theTarget, false);
            theDesignCockpit.theViewDisplayer.addObject(sClassName, null);
            theDesignCockpit.getDesignProject().theMetaProject.setProjectChangedState(true);
        }
    }

    class AddJToolBarAction extends AbstractAction {
        SuperDesignCockpit theDesignCockpit = null;
        String sClassName = null;
        IDEObjectPopupMenu theMenu;

        public AddJToolBarAction(String label, Icon icon, String theClassName, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            sClassName = theClassName;
            theDesignCockpit = objDesignCockpit;
        }

        public AddJToolBarAction(String label, String theClassName, SuperDesignCockpit objDesignCockpit) {
            super(label);
            sClassName = theClassName;
            theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            theDesignCockpit.SelectObject(theTarget, false);
            theDesignCockpit.theViewDisplayer.addObject(sClassName, null);
            theDesignCockpit.getDesignProject().theMetaProject.setProjectChangedState(true);
        }
    }

    class AddPaneAction extends AbstractAction {
        SuperDesignCockpit theDesignCockpit = null;
        String sClassName = null;
        IDEObjectPopupMenu theMenu;

        public AddPaneAction(String label, Icon icon, String theClassName, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            sClassName = theClassName;
            theDesignCockpit = objDesignCockpit;
        }

        public AddPaneAction(String label, String theClassName, SuperDesignCockpit objDesignCockpit) {
            super(label);
            sClassName = theClassName;
            theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            theDesignCockpit.SelectObject(theTarget, false);
            theDesignCockpit.theViewDisplayer.addObject(sClassName, null);

            JTabbedPane tabbedPane = ((JTabbedPane)theTarget.theVisualObject);
            tabbedPane.setSelectedIndex(tabbedPane.getTabCount() -1);

            theDesignCockpit.getDesignProject().theMetaProject.setProjectChangedState(true);
        }
    }

    class AddTabControlEditorActionAction extends AbstractAction {
        SuperDesignCockpit theDesignCockpit = null;
        String sClassName = null;
        IDEObjectPopupMenu theMenu;

        public AddTabControlEditorActionAction(SuperDesignCockpit objDesignCockpit) {
            super(objDesignCockpit.theLanguageManager.getMessage("TabControlEditorDialog.label", "Tab Control Editor"));
            theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            theDesignCockpit.showHelper(theTarget, "TabTitle");
        }
    }

    class ExpandContractAction extends AbstractAction {
        SuperDesignCockpit theDesignCockpit;
        public ExpandContractAction(SuperDesignCockpit theDesignCockpit) {
            this.theDesignCockpit = theDesignCockpit;
        }
        public void actionPerformed(ActionEvent e) {
            if (theTarget.theVisualObject instanceof JAScrollingPanel) {
                JAScrollingPanel thePanel = (JAScrollingPanel) theTarget.theVisualObject;
                boolean bExpansionState = thePanel.getExpansionState();
                if (bExpansionState)
                    thePanel.reduce();
                else
                    thePanel.expand();
            }
        }

    }

    class CutSelectedObjectAction extends AbstractAction {
        SuperDesignCockpit theDesignCockpit = null;
        MetaCloneMode theMode = new MetaCloneMode(MetaCloneMode.deepCopy);

        public CutSelectedObjectAction(String label, Icon icon, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            DesignProject theSelectedProject = theDesignCockpit.getDesignProject();
            MetaObject theNewSelectedObject = null;
            if (theSelectedProject == null)
                return;
            theDesignCockpit.theClipboardController.removeAllClipboardObjects();
            ArrayList objsToDelete = new ArrayList(0);
            ArrayList objsParents = new ArrayList(0);
            for (int i = 0; i < theSelectedProject.getSelectedObjectCount(); i++) {
                if (i==0)
                    theNewSelectedObject = theSelectedProject.getSelectedObject(i).theParentObject;
                objsToDelete.add(theSelectedProject.getSelectedObject(i));
                objsParents.add(theSelectedProject.getSelectedObject(i).theParentObject);
            }
            theSelectedProject.theUndoRedoController.createCutEvent(objsParents, objsToDelete);
            for (int i = 0; i < theSelectedProject.getSelectedObjectCount(); i++) {
                // add object to clipboard
                MetaObject theMetaObject = theSelectedProject.getSelectedObject(i);
                if ((theMetaObject != null) && (theMetaObject.isFrame() == false) && (theMetaObject.isAbalet() == false)) {
                    theDesignCockpit.theClipboardController.addClipboardObject(theMetaObject.Clone(theMode, null, true));
                    theDesignCockpit.theViewDisplayer.remove(theMetaObject.theVisualObject);
                    theDesignCockpit.theObjectTreeViewPane.removeObject(theMetaObject);
                    theSelectedProject.deselectObject(theMetaObject);
                    i--;
                    theMetaObject.DeleteObject(theDesignCockpit.theCurrentDesignProject.theMetaProject, theDesignCockpit);
                }
            }
            theDesignCockpit.deselectObjects();
            theDesignCockpit.theClipboardController.setClipboardContent(IDEClipboardController.CLIPBOARD_OBJECT);
            theDesignCockpit.theClipboardController.theCloneMode = MetaCloneMode.deepCopy;
            theDesignCockpit.theClipboardController.setClipboardBufferingAction(this);
            theSelectedProject.deselectObjects();
            theDesignCockpit.SelectObject(theNewSelectedObject, false);
            theDesignCockpit.getDesignProject().theMetaProject.setProjectChangedState(true);
        }
    }


//    class HelpAction extends AbstractAction {
//        SuperDesignCockpit theDesignCockpit = null;
//
//        public HelpAction(String label, Icon icon, SuperDesignCockpit objDesignCockpit) {
//            super(label, icon);
//            theDesignCockpit = objDesignCockpit;
//        }
//
//        public HelpAction(String label, SuperDesignCockpit objDesignCockpit) {
//            super(label);
//            theDesignCockpit = objDesignCockpit;
//        }
//
//        public void actionPerformed(ActionEvent evt) {
//        }
//    }

}
