/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.renderer.common.MetaObject;

import javax.swing.border.Border;
import javax.swing.*;
import java.awt.*;

public class IDEStatusBar extends JAPanel {
    private final SuperDesignCockpit theCockpit;
    private final LanguageManager theLanguageManager;

    JALabel theProjectName = new JALabel();
    JALabel theEditorStatus = new JALabel();
    JALabel theSelectedObject = new JALabel();
    JALabel theLanguage = new JALabel();


    public IDEStatusBar (SuperDesignCockpit theCockpit, LanguageManager theLanguageManager) {
        this.theCockpit = theCockpit;
        this.theLanguageManager = theLanguageManager;
        GridLayout theLayout = new GridLayout(1, 5, 20, 0);
        setLayout(theLayout);
        Border lineborder = BorderFactory.createLineBorder(Color.GRAY);
        Border paddedLineBorder = BorderFactory.createCompoundBorder(lineborder, BorderFactory.createEmptyBorder(2, 5,2, 5));

        setBorder(BorderFactory.createEmptyBorder(2, 1, 1, 1));

        theProjectName.setBorder(paddedLineBorder);
        add(theProjectName);

        theEditorStatus.setBorder(paddedLineBorder);
        add(theEditorStatus);

        theSelectedObject.setBorder(paddedLineBorder);
        add(theSelectedObject);

        theLanguage.setBorder(paddedLineBorder);
        //setLanguage("Deutsch (Default)");
        add(theLanguage);
    }

    public void setLanguage (String sLanguage) {
        String sLanguageKey = "StatusBar.Language.label";
        String sMessage = "Language: {0}";

        theLanguage.setText(theLanguageManager.expandMessage(sLanguageKey, sMessage, sLanguage));
    }

    public void setProjectStatus (String sProjectName) {
        String sLanguageKey = "StatusBar.Project.label";
        String sDefaultMessage = "Project: {0}";

        theProjectName.setText(theLanguageManager.expandMessage(sLanguageKey, sDefaultMessage, sProjectName));
    }

    public void setEditorStatus (int iPos, int iRow, int iColumn) {
        String sLanguageKey = "StatusBar.TextPosition.label";
        String sMessage = "Pos: {0}, Row: {1}, Col: {2}";

        theEditorStatus.setText(theLanguageManager.expandMessage(sLanguageKey, sMessage, Integer.toString(iPos), Integer.toString(iRow), Integer.toString(iColumn)));
    }

    public void setSelectedObject (MetaObject theObject) {
        String sDefaultMessage;
        String sLanguageKey;

        if (theObject == null) {
            sLanguageKey = "StatusBar.ObjectClass.NoObjectSelected.label";
            sDefaultMessage = "No Object Selected.";
            theSelectedObject.setText(theLanguageManager.getMessage(sLanguageKey, sDefaultMessage));
        } else {
            sLanguageKey = "StatusBar.ObjectClass.label";
            sDefaultMessage = "Object: {0}, Class: {1}";
            String sObjectName = theObject.getName();
            String sClassName = theObject.theClass.getMetadata().sClassName;
            theSelectedObject.setText(theLanguageManager.expandMessage(sLanguageKey, sDefaultMessage, sObjectName, sClassName));
        }
    }

}
