/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;

import javax.swing.*;
import javax.swing.BorderFactory;
import javax.swing.event.TableModelEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;

/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

public class IDETabControlEditor extends AbstractPropertyHelper {
    public boolean execute (MetaObject theObject, String sPropertyName, SuperDesignCockpit theDesignCockpit) {
        IDETabControlEditorDialog dialog = new IDETabControlEditorDialog(theObject, sPropertyName, theDesignCockpit);
        return true;
    }
}

class IDETabPageDescriptor {
    MetaObject theMetaObject;
    String sTitle;
    String sObjectName;

    public IDETabPageDescriptor(MetaObject theMetaObject, String sTitle, String sObjectName) {
        this.theMetaObject = theMetaObject;
        this.sTitle = sTitle;
        this.sObjectName = sObjectName;
    }
}

class IDETabControlEditorTableModel extends AbstractTableModel {

    MetaObject theMetaObject = null;
    ArrayList theTabPages = null;
    IDETabControlEditorTable theTable = null;
    int[] tabPageIndex = null;
    private final SuperDesignCockpit theDesignCockpit;

    public IDETabControlEditorTableModel(SuperDesignCockpit theDesignCockpit) {
        this.theDesignCockpit = theDesignCockpit;
    }

    public void setArrayIndex(int row, int value) {
        tabPageIndex[row] = value;
        // Tell the table that it has changed.
        TableModelEvent event = new TableModelEvent(this, row, row);
        theTable.tableChanged(event);
    }

    public int getRowCount() {
        if (theTabPages == null)
            return 0;
        else
            return theTabPages.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public void setValueAt(Object theNewValue, int row, int column) {
        IDETabPageDescriptor theDescriptor = (IDETabPageDescriptor) theTabPages.get(row);
        if (theDescriptor != null) {
            if (column == 0) {  // object name
                theDescriptor.sObjectName = (String) theNewValue;
            } else {  //object title
                theDescriptor.sTitle = (String) theNewValue;
            }
        }
    }

    public Object getValueAt(int row, int column) {
        IDETabPageDescriptor theDescriptor = (IDETabPageDescriptor) theTabPages.get(row);
        if (theDescriptor != null) {
            if (column == 0) {
                return theDescriptor.sObjectName;
            } else {
                return theDescriptor.sTitle;
            }
        }
        return "";
    }

    public Class getColumnClass(int iColumn) {
        String theClassName = "";
        return theClassName.getClass();
    }

    public boolean isCellEditable(int row, int column) {
        if (column == 0)
            return false;
        else
            return true;
    }

    public String getColumnName(int iColumn) {
        if (iColumn == 0)
            return theDesignCockpit.theLanguageManager.getMessage("TabControlEditorDialog.TabName.label", "Tab Page Name");
        else
            return theDesignCockpit.theLanguageManager.getMessage("TabControlEditorDialog.TabTitle.label", "Title (NLS = [Right Click])");
    }

    protected void Load(IDETabControlEditorTable objTable) {
        theTabPages = new ArrayList();
        if (theMetaObject != null) {
            MetaObject thePage = theMetaObject.theFirstChild;
            int iPage = 0;
            while (thePage != null) {
                MetaPropertyValueEx pvValue = theMetaObject.getPropertyValue("TabTitle", iPage++);
                String theTitle = "";
                if (pvValue != null)
                    theTitle = new String(pvValue.getStringValue());
                IDETabPageDescriptor theDescriptor = new IDETabPageDescriptor(thePage, theTitle, thePage.getName());
                theTabPages.add(theDescriptor);
                thePage = thePage.theNextObject;
            }
        }
    }

    protected void clear() {
        theTabPages = new ArrayList();
    }
}

class IDETabControlEditorTableMouseListener implements MouseListener {
    IDETabControlEditorTable theTable;

    public IDETabControlEditorTableMouseListener(IDETabControlEditorTable theTable) {
        this.theTable = theTable;
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.getButton() != MouseEvent.BUTTON1) {
            Point pt = evt.getPoint();
            int iRow = theTable.rowAtPoint(pt);
            new AbaNLSSelector(theTable.theModel.theMetaObject,  "TabTitle", iRow, theTable.theDesignCockpit, theTable);
        }
    }

    public void mouseReleased(MouseEvent evt) {
    }

}


class IDETabControlEditorTable extends JATable {

    public IDETabControlEditorTableModel theModel = null;
    public SuperDesignCockpit theDesignCockpit;
    public IDETabControlEditorTable(IDETabControlEditorTableModel theTableModel, SuperDesignCockpit theDesignCockpit) {
        super(theTableModel);
        theModel = theTableModel;
        this.theDesignCockpit = theDesignCockpit;
        this.addMouseListener(new IDETabControlEditorTableMouseListener(this));
    }

    public void tableChanged(TableModelEvent evt) {
        super.tableChanged(evt);
    }

    public void Load() {
        theModel.Load(this);
        repaint();
    }

    public void resetContents() {
        theModel.clear();
        repaint();
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableColumn tableColumn = getColumnModel().getColumn(column);
        TableCellRenderer renderer = tableColumn.getCellRenderer();
        if (renderer == null) {
            renderer = getDefaultRenderer(theModel.getColumnClass(column));
        }
        return renderer;
    }

    public TableCellEditor getCellEditor(int row, int column) {

        TableColumn tableColumn = getColumnModel().getColumn(column);
        TableCellEditor editor = tableColumn.getCellEditor();
        if (editor == null)
            editor = getDefaultEditor(theModel.getColumnClass(column));
        return editor;
    }

    public void newValueSelected(String sNewValue, String sPropertyName, Integer theRow) {
        theModel.setValueAt(sNewValue, theRow.intValue(), 1);
    }

    public void commitEditingChange() {
        if (isEditing()) {
            if (getCellEditor() != null)
                getCellEditor().stopCellEditing();
        }
    }
}

 class IDETabControlEditorDialog extends JADialog {
    MetaObject theObject;
    IDETabControlEditorTableModel theModel;
    IDETabControlEditorTable theTabControlTable;
    JAScrollPane theTabControlScrollPane;
    UpButtonAction theUpAction;
    DownButtonAction theDownAction;
    DeleteButtonAction theDeleteAction;
    OKButtonAction theOKAction;
    CancelButtonAction theCancelAction;
    SuperDesignCockpit theDesignCockpit;
    JAButton theUpButton;
    JAButton theDownButton;
    JAButton theDeleteButton;
    JAButton theOKButton;
    JAButton theCancelButton;

    private boolean m_structureChanged; // true, if the up, down or delete actions were invoked

    public IDETabControlEditorDialog(MetaObject theObject, String sPropertyName, SuperDesignCockpit theDesignCockpit) {
        super(theDesignCockpit, null, true, false);
        theModel = new IDETabControlEditorTableModel(theDesignCockpit);
        String sTitle = theDesignCockpit.theLanguageManager.getMessage("TabControlEditorDialog.label", "Tab Control Editor");
        setTitle(sTitle);
        this.theDesignCockpit = theDesignCockpit;
        this.theObject = theObject;
        this.theModel.theMetaObject = theObject;
        theTabControlTable = new IDETabControlEditorTable(theModel, theDesignCockpit);
        theTabControlScrollPane = new JAScrollPane(theTabControlTable);
        this.theTabControlTable.Load();
        theUpAction = new UpButtonAction(this, theObject);
        theDownAction = new DownButtonAction(this, theObject);
        theDeleteAction = new DeleteButtonAction(this, theObject);
        theOKAction = new OKButtonAction(this, theObject);
        theCancelAction = new CancelButtonAction(this, theObject);

        theUpButton = new JAButton(theUpAction);
        theDownButton = new JAButton(theDownAction);
        theDeleteButton = new JAButton(theDeleteAction);
        theOKButton = new JAButton(theOKAction);
        theCancelButton = new JAButton(theCancelAction);

        Container pane = getContentPane();
        pane.setLayout(new BorderLayout());

        JAPanel pnlTable = new JAPanel();
        pnlTable.setBorder(BorderFactory.createEmptyBorder(10,10,10,5));
        pnlTable.setLayout(new BorderLayout());
        pnlTable.add(theTabControlScrollPane, BorderLayout.CENTER);
        pane.add(pnlTable, BorderLayout.CENTER);

        JAPanel pnlButtons = new JAPanel();
        pnlButtons.setBorder(BorderFactory.createEmptyBorder(10,5,10,10));
        pnlButtons.setLayout(new BorderLayout());

        JAPanel pnlTopButtons = new JAPanel(new BorderLayout(0, 5));
        JAPanel pnlMiddleButtons = new JAPanel(new BorderLayout());
        JAPanel pnlBottomButtons = new JAPanel(new BorderLayout(0, 5));

        pnlMiddleButtons.setBorder(BorderFactory.createEmptyBorder(50, 0, 20, 0));

        pnlTopButtons.add(theUpButton, BorderLayout.NORTH);
        pnlTopButtons.add(theDownButton, BorderLayout.SOUTH);

        pnlMiddleButtons.add(theDeleteButton, BorderLayout.NORTH);

        pnlBottomButtons.add(theOKButton, BorderLayout.NORTH);
        pnlBottomButtons.add(theCancelButton, BorderLayout.SOUTH);

        pnlButtons.add(pnlTopButtons, BorderLayout.NORTH);
        pnlButtons.add(pnlMiddleButtons, BorderLayout.CENTER);
        pnlButtons.add(pnlBottomButtons, BorderLayout.SOUTH);

        pane.add(pnlButtons, BorderLayout.EAST);


        theTabControlTable.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                enableButtons();
            }
        });
        theTabControlTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

        Dimension size = new Dimension(450, 300);
        setSize(size);
        setMinimumMaximumFrameSize(9999, size.width, 9999, size.height);
        setLocationRelativeTo(null);

        show(null);
    }

     private void enableButtons() {
         int iRow = theTabControlTable.getSelectedRow();
         theUpButton.setEnabled(iRow > 0);
         theDownButton.setEnabled(iRow < theTabControlTable.getModel().getRowCount() -1);
         theDeleteButton.setEnabled(iRow != -1);
     }

     class UpButtonAction extends AbstractAction {
        MetaObject theMetaObject = null;
        IDETabControlEditorDialog theEditor = null;

        public UpButtonAction(IDETabControlEditorDialog theEditor, MetaObject theMetaObject) {
            super(theDesignCockpit.theLanguageManager.getMessage("Up.label", "Up"));
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            theEditor.theTabControlTable.commitEditingChange();
            IDETabControlEditorTable theTable = theEditor.theTabControlTable;
            IDETabControlEditorTableModel theModel = theEditor.theModel;
            int iRowFrom = theTable.getSelectedRow();
            if (iRowFrom > 0) {
                int iRowTo = iRowFrom -1;
                Object objToRaise = theModel.theTabPages.get(iRowFrom);
                Object objToLower = theModel.theTabPages.get(iRowTo);
                theModel.theTabPages.set(iRowFrom, objToLower);
                theModel.theTabPages.set(iRowTo, objToRaise);

                // Keep the moved item as the selcted one...
                theTable.getSelectionModel().setSelectionInterval(iRowTo, iRowTo);

                theTable.repaint();

                m_structureChanged = true;
            }
            theEditor.theUpButton.setFocusPainted(false);
        }
    }

    class DownButtonAction extends AbstractAction {
        MetaObject theMetaObject = null;
        IDETabControlEditorDialog theEditor = null;

        public DownButtonAction(IDETabControlEditorDialog theEditor, MetaObject theMetaObject) {
            super(theDesignCockpit.theLanguageManager.getMessage("Down.label", "Down"));
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            theEditor.theTabControlTable.commitEditingChange();
            IDETabControlEditorTable theTable = theEditor.theTabControlTable;
            IDETabControlEditorTableModel theModel = theEditor.theModel;
            int iRowFrom = theTable.getSelectedRow();
            int iRowCount = theTable.getRowCount();
            if ((iRowFrom != -1) && (iRowFrom < (iRowCount - 1))) {
                int iRowTo = iRowFrom +1;
                Object objToRaise = theModel.theTabPages.get(iRowTo);
                Object objToLower = theModel.theTabPages.get(iRowFrom);
                theModel.theTabPages.set(iRowTo, objToLower);
                theModel.theTabPages.set(iRowFrom, objToRaise);

                // Keep the moved item as the selcted one...
                theTable.getSelectionModel().setSelectionInterval(iRowTo, iRowTo);

                theTable.repaint();

                m_structureChanged = true;
            }
            theEditor.theDownButton.setFocusPainted(false);
        }
    }

    class DeleteButtonAction extends AbstractAction {
        MetaObject theMetaObject = null;
        IDETabControlEditorDialog theEditor = null;

        public DeleteButtonAction(IDETabControlEditorDialog theEditor, MetaObject theMetaObject) {
            super(theDesignCockpit.theLanguageManager.getMessage("Delete.label", "Delete"));
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            theEditor.theTabControlTable.commitEditingChange();
            IDETabControlEditorTable theTable = theEditor.theTabControlTable;
            IDETabControlEditorTableModel theModel = theEditor.theModel;
            int iRow = theTable.getSelectedRow();
            if (iRow != -1) {
                theModel.theTabPages.remove(iRow);

                // try to set the selection to the nearest valid row...
                final int iRowCount = theModel.getRowCount();
                if (iRowCount == 0) { // cannot make a new selection...
                    theTable.getSelectionModel().clearSelection();
                } else if (iRow == iRowCount ) { // last row...
                    theTable.getSelectionModel().setSelectionInterval(iRowCount -1, iRowCount -1);
                } else { // middle, so keep relative row...
                    theTable.getSelectionModel().setSelectionInterval(iRow, iRow);
                }
                enableButtons();
                theTable.updateUI();

                m_structureChanged = true;
            }
            theEditor.theDeleteButton.setSelected(false);
        }
    }

    class OKButtonAction extends AbstractAction {
        MetaObject theMetaObject = null;
        IDETabControlEditorDialog theEditor = null;

        public OKButtonAction(IDETabControlEditorDialog theEditor, MetaObject theMetaObject) {
            super(theDesignCockpit.theLanguageManager.getMessage("Dialogs.OK", "OK"));
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            theEditor.theTabControlTable.commitEditingChange();
            IDETabControlEditorTable theTable = theEditor.theTabControlTable;
            IDETabControlEditorTableModel theModel = theEditor.theModel;
            DesignTabbedPane theTabPane = (DesignTabbedPane) theMetaObject.theVisualObject;

            theMetaObject.theFirstChild = null;
            theMetaObject.theLastChild = null;
            int iRow = 0;
            theTabPane.bAllowRemoveTab = false;
            theTabPane.removeAll();
            theTabPane.bAllowRemoveTab = true;
            theDesignCockpit.getDesignProject().theUndoRedoController.createChangePropertyEvent(theMetaObject, "TabTitle");
            while (iRow < theTable.getRowCount()) {
                IDETabPageDescriptor theDescriptor = (IDETabPageDescriptor) theModel.theTabPages.get(iRow);
                theDescriptor.theMetaObject.setName(theDescriptor.sObjectName);
                theDescriptor.theMetaObject.thePreviousObject = null;
                theDescriptor.theMetaObject.theNextObject = null;
                theMetaObject.addObject(theDescriptor.theMetaObject);
                boolean bGlobal = (theDescriptor.sTitle.startsWith("@AbaNLS"));
                theMetaObject.setPropertyValue("TabTitle", iRow, 0, theDescriptor.sTitle, bGlobal);
                theTabPane.addTab(theDescriptor.sTitle, theDescriptor.theMetaObject.theVisualObject);
                iRow++;
            }
            theEditor.removeAll();
            theEditor.hide();
            theEditor = null;
            final MetaProject metaProject = theDesignCockpit.getDesignProject().theMetaProject;
            metaProject.setProjectChangedState(true);
            if (m_structureChanged) {
                theDesignCockpit.theObjectTreeViewPane.redisplayProject();
            }

        }
    }

    class CancelButtonAction extends AbstractAction {
        MetaObject theMetaObject = null;
        IDETabControlEditorDialog theEditor = null;

        public CancelButtonAction(IDETabControlEditorDialog theEditor, MetaObject theMetaObject) {
            super(theDesignCockpit.theLanguageManager.getMessage("Dialogs.Cancel", "Cancel"));
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            theEditor.removeAll();
            theEditor.hide();
            theEditor = null;
        }
    }

}
