/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import java.util.Stack;

/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

public class IDEUndoRedoStack {
    java.util.Stack theUndoStack = new Stack();
    java.util.Stack theRedoStack = new Stack();
    static final int stack_size = 20;
    private IDEUndoRedoController theController;
    String sUndoHint;
    String sRedoHint;

    public IDEUndoRedoStack(IDEUndoRedoController theController) {
        this.theController = theController;
    }

    public IDEUndoRedoStackElement popUndo() {
        IDEUndoRedoStackElement element = (IDEUndoRedoStackElement) theUndoStack.pop();
        IDEUndoRedoStackElement nextElement = null;
        try {
            nextElement = (IDEUndoRedoStackElement) theUndoStack.peek();
        } catch (Exception e) {
        }
        if (nextElement != null)
            sUndoHint = nextElement.getDescription();
        else
            sUndoHint = null;
        theController.updateHint();
        return element;
    }

    public IDEUndoRedoStackElement popRedo() {
        IDEUndoRedoStackElement element = null;
        element = (IDEUndoRedoStackElement) theRedoStack.pop();
        IDEUndoRedoStackElement nextElement = null;
        try {
            nextElement = (IDEUndoRedoStackElement) theRedoStack.peek();
        } catch (Exception e) {
        }
        if (nextElement != null)
            sRedoHint = nextElement.getDescription();
        else
            sRedoHint = null;
        theController.updateHint();
        return element;
    }

    public void pushUndo(IDEUndoRedoStackElement element) {
        if (theUndoStack.size() == stack_size) {
            theUndoStack.remove(stack_size - 1);
        }
        theUndoStack.push(element);
        sUndoHint = element.getDescription();
        theController.updateHint();
    }

    public void pushRedo(IDEUndoRedoStackElement element) {
        if (theRedoStack.size() == stack_size) {
            theRedoStack.remove(stack_size - 1);
        }
        theRedoStack.push(element);
        sRedoHint = element.getDescription();
        theController.updateHint();
    }
}