/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.IDEComponentPaletteNode;
import ch.abacus.designcockpit.external.IDEFocusRequester;

import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

/**
 * Title:        uifactory
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */


public class IDEViewDisplayerComponentMouseListener implements MouseListener {
    MetaObject theDesignObject;
    MetaObject theDragAxisObject;
    Component theComponent;
    Cursor savedCursor = null;
    SuperDesignCockpit theDesignCockpit = null;

    public IDEViewDisplayerComponentMouseListener (MetaObject objDesignObject,
                                                   MetaObject objDragAxisObject,
                                                   SuperDesignCockpit theDesignCockpit,
                                                   Component objComponent) {
        theDesignObject = objDesignObject;
        theDragAxisObject = objDragAxisObject;
        theComponent = objComponent;
        this.theDesignCockpit = theDesignCockpit;
    }

    public void mouseClicked (MouseEvent evt) {
    }

    public void mouseEntered (MouseEvent evt) {
    }

    public void mouseExited (MouseEvent evt) {
    }

    public void mousePressed (MouseEvent evt) {
        if ((theDesignCockpit.getMouseSelectState()) && (!evt.isShiftDown())) {
            if (evt.getButton() == evt.BUTTON1) {
                boolean bCtrl = evt.isControlDown();
                if (bCtrl == false) {
                    theDesignCockpit.deselectObjects();
                    theDesignCockpit.SelectObject(theDesignObject, bCtrl);
                    IDEFocusRequester.requestFocus(theDesignObject.theVisualObject);
                } else {
                    if (theDesignCockpit.getDesignProject().isSelected(theDesignObject))
                        theDesignCockpit.deselectObject(theDesignObject);
                    else
                        theDesignCockpit.SelectObject(theDesignObject, bCtrl);
                }
            }
            theDragAxisObject.ptDrag = evt.getPoint();
            if (evt.isPopupTrigger() == false) {
                savedCursor = theDesignObject.theVisualObject.getCursor();
                theDesignObject.theVisualObject.setCursor(new Cursor(Cursor.HAND_CURSOR));
            }
            theDesignObject.bDragged = false;
            showPopup(evt);
        } else {
            Point pt = evt.getPoint();
            Point ptViewDisplayerScreen = theDesignCockpit.theViewDisplayer.getLocationOnScreen();
            Point ptObjectLocation = theDesignObject.theVisualObject.getLocationOnScreen();
            pt.x += (ptObjectLocation.x - ptViewDisplayerScreen.x);
            pt.y += (ptObjectLocation.y - ptViewDisplayerScreen.y);
            // new object receives mouse pressed message too causing duplicates.
            if (theDesignCockpit.importManager.test(evt.getWhen())) {
                // if the component to create is actually a Customizer CustomizerDataElementInterface, then create via the Customizer so that sub-elements can be created too...
                IDEComponentPaletteNode selectedNode = theDesignCockpit.theComponentPalettePane.theTree.getSelectedNode();
                if (selectedNode != null) {
                    if (selectedNode.isCustomizerDataElement())
                        theDesignCockpit.theCustomizer.importElement(theDesignObject, pt, evt.isShiftDown());
                    else
                        theDesignCockpit.theViewDisplayer.importObject(theDesignObject, pt, evt.isShiftDown(), null);
                }
            }
            theDesignCockpit.setMouseSelectState(true);
            IDEFocusRequester.requestFocus(theDesignObject.theVisualObject);
        }
    }

    public void mouseReleased (MouseEvent evt) {
        theDesignCockpit.theViewDisplayer.setMouseCoordinates(evt.getX(), evt.getY());
        if (theDesignCockpit.getMouseSelectState()) {
            theDesignObject.theVisualObject.setCursor(savedCursor);
            showPopup(evt);
        }
        if (theDesignObject.bDragged) {
            endDragging(theDesignObject);
        }
        theDesignCockpit.allowDragging(true);
    }

    private void showPopup (MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            theDesignCockpit.theLastPopupMenu = theDesignCockpit.theViewDisplayer.thePopupMenu;
            Point pt = evt.getPoint();
            Point ptViewDisplayerScreen = theDesignCockpit.theViewDisplayer.getLocationOnScreen();
            Point ptObjectLocation = theDesignObject.theVisualObject.getLocationOnScreen();
            // ptLastPopupLocation is the relative offset of the menu from the origin of the view displayer.
            theDesignCockpit.theViewDisplayer.thePopupMenu.ptActualStrikePoint = new Point(pt.x, pt.y);
            pt.x += (ptObjectLocation.x - ptViewDisplayerScreen.x);
            pt.y += (ptObjectLocation.y - ptViewDisplayerScreen.y);
            theDesignCockpit.theViewDisplayer.thePopupMenu.ptLastPopupLocation = new Point(pt.x, pt.y);
            theDesignCockpit.theViewDisplayer.thePopupMenu.show(theDesignCockpit.theViewDisplayer,
                    pt.x, pt.y, theDesignObject);
        }
    }

    void beginResizing (MetaObject theMetaObject) {
        theMetaObject.bResizing = true;
        theDesignCockpit.getDesignProject().theUndoRedoController.createChangeSizeEvent(theMetaObject);
    }

    void beginDragging (MetaObject theMetaObject) {
        int iSelectedObjectCount = theDesignCockpit.getDesignProject().getSelectedObjectCount();
        ArrayList theObjects = new ArrayList(iSelectedObjectCount);
        for (int i = 0; i < iSelectedObjectCount; i++) {
            theObjects.add(theDesignCockpit.getDesignProject().getSelectedObject(i));
        }
        theDesignCockpit.getDesignProject().theUndoRedoController.createChangeLocationEvent(theObjects);
        theMetaObject.bDragged = true;
    }

    // If size didn't change, remove the event
    void endResizing (MetaObject theMetaObject) {
        theMetaObject.bResizing = false;
    }

    void endDragging (MetaObject theMetaObject) {
        theMetaObject.doEndDrag();
    }

}


class IDEViewDisplayerComponentMouseMotionListener implements MouseMotionListener {
    MetaObject theDesignObject;
    Component theComponent;
    SuperDesignCockpit theDesignCockpit;

    public IDEViewDisplayerComponentMouseMotionListener (MetaObject objDesignObject,
                                                         Component objComponent,
                                                         SuperDesignCockpit theDesignCockpit) {
        theDesignObject = objDesignObject;
        theComponent = objComponent;
        this.theDesignCockpit = theDesignCockpit;
    }

    public void mouseMoved (MouseEvent e) {
    }

    public void mouseDragged (MouseEvent e) {
//        if ((theDesignObject.bBottomAnchoring==false) && (theDesignObject.bTopAnchoring==false) &&
//          (theDesignObject.bRightAnchoring==false) && (theDesignObject.bLeftAnchoring==false)) {
        if (theDesignCockpit.getAllowDragging() == false)
            return;
        MetaObject parent = theDesignObject.theParentObject;
        if (parent != null) {
            boolean bSplitParent = parent.isHorzSplit() || parent.isVertSplit();
            if (bSplitParent)  // don't let fake panels drag.
                return;
        }
        Point pt = e.getPoint();
        Point ptViewDisplayerScreen = theDesignCockpit.theViewDisplayer.getLocationOnScreen();
        Point ptObjectLocation = theDesignObject.theVisualObject.getLocationOnScreen();
        if (theDesignObject.bDragged == false) {
            beginDragging(theDesignObject);
        }
        theDesignCockpit.dragAction(theDesignObject, e, ptViewDisplayerScreen, ptObjectLocation, pt);
    }

    void beginResizing (MetaObject theMetaObject) {
        theMetaObject.bResizing = true;
        theDesignCockpit.getDesignProject().theUndoRedoController.createChangeSizeEvent(theMetaObject);
    }

    void beginDragging (MetaObject theMetaObject) {
        int iSelectedObjectCount = theDesignCockpit.getDesignProject().getSelectedObjectCount();
        ArrayList theObjects = new ArrayList(iSelectedObjectCount);
        for (int i = 0; i < iSelectedObjectCount; i++) {
            theObjects.add(theDesignCockpit.getDesignProject().getSelectedObject(i));
        }
        theDesignCockpit.getDesignProject().theUndoRedoController.createChangeLocationEvent(theObjects);
        theMetaObject.bDragged = true;
    }

    // If size didn't change, remove the event
    void endResizing (MetaObject theMetaObject) {
        theMetaObject.bResizing = false;
    }

    void endDragging (MetaObject theMetaObject) {
        theMetaObject.bDragged = false;
    }
}


