/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.layout.AnchoringLayoutManager;

import javax.swing.*;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import java.awt.*;
import java.awt.event.ActionEvent;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: Jun 17, 2003
 * Time: 3:51:58 PM
 * To change this template use Options | File Templates.
 */

class JarOpenFileDialogFilter implements JarContentsFilter {
    public boolean checkFile(String sFile) {
        sFile = sFile.toLowerCase();
        if (sFile.endsWith("proz") || sFile.endsWith("proj"))
            return true;
        return false;
    }

}


class JarOpenFileDialogTreeListener implements TreeSelectionListener {

    JarOpenFileDialog theDialog;
    JarContentsTreeNode theSelectedNode;

    public JarOpenFileDialogTreeListener(JarOpenFileDialog theDialog) {
        this.theDialog = theDialog;
    }

    public void valueChanged(TreeSelectionEvent evt) {
        TreePath thePath = evt.getPath();
        theSelectedNode = (JarContentsTreeNode) thePath.getLastPathComponent();
        if (theSelectedNode != null) {
            if (theSelectedNode.getChildCount() > 0)
                theDialog.okButton.setEnabled(false);
            else
                theDialog.okButton.setEnabled(true);
            theDialog.okButton.repaint();
        }
    }
}


public class JarOpenFileDialog {
    public String sJarName;
    public JarContentsTreeNode theSelectedEntry;
    public JarOpenFileDialogTreeListener jarContentsTreeListener;
    public JarOpenFileDialog theProjectWrapper = this;
    protected javax.swing.JDialog jarOpenDialog = new JDialog();
    protected JarContentsTree jarContentsTree;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JLabel titleLabel = new JLabel();
    boolean bReady = false;

    public void initializeInterface() {
        //  Get the content pane of the frame.
        JPanel contentPanejarOpenDialog =
                (JPanel) jarOpenDialog.getContentPane();
        // Set the layout.
        AnchoringLayoutManager layoutManagerjarOpenDialog = new AnchoringLayoutManager();
        contentPanejarOpenDialog.setLayout(layoutManagerjarOpenDialog);
        jarOpenDialog.setBackground(new Color(192, 192, 192));
        jarOpenDialog.setForeground(new Color(0, 0, 0));
        jarOpenDialog.setLocation(new java.awt.Point(0, 248));
        jarOpenDialog.setSize(new Dimension(600, 400));
        jarOpenDialog.setTitle("Select File From JAR");
        jarContentsTree = new JarContentsTree(this.sJarName, new JarOpenFileDialogFilter());
        JScrollPane theTreePane = new JScrollPane(jarContentsTree);
        Font font$$$jarContentsTree = new Font("Arial", Font.PLAIN, 11);
        jarContentsTree.setBackground(new Color(255, 255, 255));
        jarContentsTree.setForeground(new Color(0, 0, 0));
        theTreePane.setLocation(new java.awt.Point(24, 72));
        jarContentsTree.setSize(new Dimension(360, 288));
        theTreePane.setSize(new Dimension(360, 288));
        jarContentsTree.setFont(font$$$jarContentsTree);
        jarContentsTreeListener = new JarOpenFileDialogTreeListener(this);
        jarContentsTree.addTreeSelectionListener(jarContentsTreeListener);
        //  Add the control jarContentsTree to the content pane.
        contentPanejarOpenDialog.add(theTreePane, "jarContentsTree");
        layoutManagerjarOpenDialog.setAnchoring(theTreePane, false, false,
                false, false);
        okButton = new JButton(new OKButtonAction(this));
        Font font$$$okButton = new Font("Arial", Font.PLAIN, 11);
        okButton.setBackground(new Color(192, 192, 192));
        okButton.setForeground(new Color(0, 0, 0));
        okButton.setLocation(new java.awt.Point(448, 80));
        okButton.setSize(new Dimension(80, 24));
        okButton.setFont(font$$$okButton);
        okButton.setEnabled(false);
        //  Add the control okButton to the content pane.
        contentPanejarOpenDialog.add(okButton, "okButton");
        layoutManagerjarOpenDialog.setAnchoring(okButton, false, false, false,
                false);
        cancelButton = new JButton(new CancelButtonAction(this));
        Font font$$$cancelButton = new Font("Arial", Font.PLAIN, 11);
        cancelButton.setBackground(new Color(192, 192, 192));
        cancelButton.setForeground(new Color(0, 0, 0));
        cancelButton.setLocation(new java.awt.Point(448, 152));
        cancelButton.setSize(new Dimension(80, 24));
        cancelButton.setFont(font$$$cancelButton);
        //  Add the control cancelButton to the content pane.
        contentPanejarOpenDialog.add(cancelButton, "cancelButton");
        layoutManagerjarOpenDialog.setAnchoring(cancelButton, false, false,
                false, false);
        Font font$$$titleLabel = new Font("Arial", Font.PLAIN, 11);
        titleLabel.setBackground(new Color(192, 192, 192));
        titleLabel.setForeground(new Color(0, 0, 0));
        titleLabel.setLocation(new java.awt.Point(144, 24));
        titleLabel.setSize(new Dimension(120, 16));
        titleLabel.setFont(font$$$titleLabel);
        titleLabel.setText("Projects Within This Jar");
        //  Add the control titleLabel to the content pane.
        contentPanejarOpenDialog.add(titleLabel, "titleLabel");
        layoutManagerjarOpenDialog.setAnchoring(titleLabel, false, false,
                false, false);
        // initialize tree contents
        jarContentsTree.load();
        // Show the main window
        bReady = false;
        this.jarOpenDialog.setModal(true);
    }  // End of the initializeInterface method.


    boolean isReady() {
        return bReady;
    }

    public JarOpenFileDialog(String sJarName) {
        this.sJarName = sJarName;
        try {
            initializeInterface();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JarContentsTreeNode getSelection() {
        return theSelectedEntry;
    }

    class OKButtonAction extends AbstractAction {
        JarOpenFileDialog theEditor = null;

        public OKButtonAction(JarOpenFileDialog theEditor) {
            super("OK");
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            theSelectedEntry = this.theEditor.jarContentsTreeListener.theSelectedNode;
            theEditor.jarOpenDialog.removeAll();
            theEditor.jarOpenDialog.hide();
            theEditor = null;
            bReady = true;
        }
    }

    class CancelButtonAction extends AbstractAction {
        JarOpenFileDialog theEditor = null;

        public CancelButtonAction(JarOpenFileDialog theEditor) {
            super("Cancel");
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            theEditor.jarOpenDialog.removeAll();
            theEditor.jarOpenDialog.hide();
            theEditor = null;
            theSelectedEntry = null;
            bReady = true;
        }
    }

}
