/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide.propertyinspector;

import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.propertyinspector.core.StringEntry;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart Booth (Live Clue, inc)
 * Date: Aug 2, 2005
 * Time: 4:23:41 PM
 */
public class ConstantListFactory {
    private final MetadataDispenser m_metadataDispenser;

    private HashMap<String, ArrayList<StringEntry>> m_lists;

    public ConstantListFactory(MetadataDispenser metadataDispenser) {
        m_metadataDispenser = metadataDispenser;
        m_lists = new HashMap<String, ArrayList<StringEntry>>(10);
    }

    public ArrayList getConstantList (String sName) {
        ArrayList list = m_lists.get(sName);
        if (list != null)
            return list;
        else
            return createConstantList(sName);
    }

    private ArrayList createConstantList(String sName) {
        ArrayList<StringEntry> list = new ArrayList<StringEntry>();

        // sName could be a Group or Collection
        final MetaConstantGroup group = m_metadataDispenser.findConstantGroup(sName);
        if (group != null) {
            final ArrayList constantList = group.getConstantList();
            for (int iConstant=0; iConstant < constantList.size(); iConstant++) {
                String sConstantName = (String) constantList.get(iConstant);
                //String sConstantValue = (String) group.get(sConstantName);

                list.add(new StringEntry(sConstantName/*sConstantValue*/, sConstantName));

            }

        } else {
            final MetaConstantGroupCollection collection = m_metadataDispenser.findConstantGroupCollection(sName);
            if (collection != null) {
                final ArrayList constantList = collection.getConstantList();
                for (int iConstant=0; iConstant < constantList.size(); iConstant++) {
                    String sConstantName = (String) constantList.get(iConstant);
                    //String sConstantValue = (String) collection.get(sConstantName);

                    list.add(new StringEntry(sConstantName/*sConstantValue*/, sConstantName));

                }
            }
        }

        m_lists.put(sName, list);
        return list;
    }

}
