/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide.propertyinspector;

import ch.abacus.lib.ui.propertyinspector.display.editor.AbstractListEditor;

import javax.swing.*;
import java.util.List;
import java.util.ArrayList;
import java.awt.*;

/**
  * User: Mario Castillo , Castellum Technologies
 * Date: Sep 21, 2005
 * Time: 9:37:01 AM
  */
class ReferenceListCellRenderer extends JLabel implements ListCellRenderer
{
     public ReferenceListCellRenderer()
     {
        setOpaque(true);
     }

     public Component getListCellRendererComponent( JList list, Object value,
         int index,  boolean isSelected, boolean cellHasFocus)
     {
         if(value!=null)
         {
             String sName = value.toString();
             setText(sName);
             setBackground(isSelected ? Color.blue : Color.white);
             setForeground(isSelected ? Color.white : Color.black);
         }
         else // Blank out the selection in case Rog's components can't find the item set it to blank
         {
            setText("");
         }
         return this;
     }
}

public class ObjecReferenceListEditor extends AbstractListEditor
{

    private  ArrayList RefList= new ArrayList();

    public ObjecReferenceListEditor(boolean lazyInit)
    {
        super(lazyInit);
    }

    public ObjecReferenceListEditor(boolean lazyInit , ArrayList objectList)
    {
        super(lazyInit);
    }

    public List getItemList()
    {
        return RefList;
    }

    public int indexOf(Object value)
    {
        return RefList.indexOf(value);
    }

    public ListCellRenderer getListCellRenderer()
    {
        return new ReferenceListCellRenderer();
    }

    public void refreshList(ArrayList value)
    {
        RefList = value;
    }

    public void setValue(Object value)
    {
        comboBox.setModel(new DefaultComboBoxModel(getItemList().toArray()));
        super.setValue(value);
    }

}
