/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import javax.swing.*;
import java.awt.event.ActionEvent;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Nov 15, 2004
 * Time: 6:08:13 PM
 */
public class ActionManager {
    private final MetadataEditor theEditor;

    private AboutAction aboutAction;
    private SaveAction saveAction;
    private ExitAction exitAction;

    public ActionManager (MetadataEditor editor) {
        this.theEditor = editor;

        initializeActions();
    }

    private void initializeActions () {
        ActionInitializer initializer = new ActionInitializer();

        aboutAction = initializer.initAboutAction();
        saveAction = initializer.initSaveAction();
        exitAction = initializer.initExitAction();

    }

    public AboutAction getAboutAction () {
        return aboutAction;
    }

    public SaveAction getSaveAction () {
        return saveAction;
    }

    public ExitAction getExitAction () {
        return exitAction;
    }


    /**
     * The base class to use for all interface Actions.<p>
     */
    private abstract class InterfaceAction extends AbstractAction {

        public InterfaceAction (String sLabel, char mnemonic, KeyStroke keyStroke, String sIconName, String sDescription) {
            super(sLabel);

            if (mnemonic != '\0')
                setMnemonicKey(mnemonic);

            if ((sDescription != null) && (sDescription.length() > 0))
                setShortDescription(sDescription);

            if (keyStroke != null)
                setAcceleratorKey(keyStroke);

        }

        public InterfaceAction (ActionDescription desc) {
            this(desc.getLabel(), desc.getMnemonic(), desc.getAccelerator(), desc.getImageName(), desc.getTooltip());
        }

        private void setMnemonicKey (char mnemonic) {
            putValue(Action.MNEMONIC_KEY, new Integer(mnemonic));
        }

        private void setShortDescription (String sDescription) {
            putValue(Action.SHORT_DESCRIPTION, sDescription);
        }

        protected void setAcceleratorKey (KeyStroke keyStroke) {
            putValue(Action.ACCELERATOR_KEY, keyStroke);
        }

        public String getLabel() {
            return (String) getValue(Action.NAME);
        }

        public char getMnemonicKey() {
            return (char)((Integer) getValue(Action.MNEMONIC_KEY)).intValue();
        }


    }

    class AboutAction extends InterfaceAction {
        public AboutAction (ActionDescription description) {
            super(description);
        }

        public void actionPerformed (ActionEvent evt) {
            AboutDialog dialog = new AboutDialog(theEditor);
            dialog.show(null);
        }
    }

    class SaveAction extends InterfaceAction {
        public SaveAction (ActionDescription description) {
            super(description);
        }

        public void actionPerformed (ActionEvent evt) {
            theEditor.saveMetadata();
        }
    }

    class ExitAction extends InterfaceAction {
        public ExitAction (ActionDescription description) {
            super(description);
        }

        public void actionPerformed (ActionEvent evt) {
            theEditor.exitApplication();
        }
    }


    private class ActionInitializer {

        ExitAction initExitAction () {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Exit");
            actionDescription.setMnemonic('X');
            actionDescription.setTooltip("Exits the program");

            return new ExitAction(actionDescription);
        }

        SaveAction initSaveAction () {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Save");
            actionDescription.setMnemonic('S');
            actionDescription.setAccelerator("ctrl S");
            actionDescription.setTooltip("Save Metadata");

            return new SaveAction(actionDescription);
        }


        AboutAction initAboutAction () {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("About");
            actionDescription.setMnemonic('A');

            return new AboutAction(actionDescription);
        }

    }

    class ActionDescription {
        private String theLabel;
        private char theMnemonic;
        private KeyStroke theAccelerator;
        private String theImageName;
        private String theTooltip;

        public String getLabel () {
            return theLabel;
        }

        public void setLabel (String theLabel) {
            this.theLabel = theLabel;
        }

        public char getMnemonic () {
            return theMnemonic;
        }

        public void setMnemonic (char mnemonic) {
            this.theMnemonic = mnemonic;
        }

        public KeyStroke getAccelerator () {
            return theAccelerator;
        }

        public void setAccelerator (String sAccelerator) {
            this.theAccelerator = KeyStroke.getKeyStroke(sAccelerator);
        }

        public void setAccelerator (KeyStroke keyStroke) {
            this.theAccelerator = keyStroke;
        }

        public String getImageName () {
            return theImageName;
        }

        public void setImageName (String theImageName) {
            this.theImageName = theImageName;
        }

        public String getTooltip () {
            return theTooltip;
        }

        public void setTooltip (String theTooltip) {
            this.theTooltip = theTooltip;
        }

    }

}

