/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JAList;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Apr 13, 2004
 * Time: 4:12:17 PM
 * To change this template use Options | File Templates.
 */
public class ManageCollectionGroupsDialog extends JDialog {
    final MetadataEditor theEditor;
    JAList lstGroups = null;
    MetaConstantGroupCollection theCollection; // the collection being managed

    public ManageCollectionGroupsDialog (MetadataEditorPageConstantCollections pageCollections, MetaConstantGroupCollection collection, String sCaption, String sCollectionTitle) {
        super(pageCollections.editor, sCaption, true);
        lstGroups = new JAList();
        theEditor = pageCollections.editor;
        theCollection = collection;
        initDisplay(sCollectionTitle);
        populateDisplay();
    }

    private void initDisplay (String sCaption) {
        Container pane = getContentPane();
        pane.setLayout(new BorderLayout());
        JAPanel pnlGroups = new JAPanel(new BorderLayout());
        pnlGroups.setBorder(BorderFactory.createTitledBorder(sCaption));
        pnlGroups.add(new JScrollPane(lstGroups), BorderLayout.CENTER);
        pane.add(pnlGroups, BorderLayout.CENTER);
        JAPanel pnlDialogButtons = new JAPanel(new FlowLayout(FlowLayout.RIGHT, 5, 5));

        JAButton btnOK = new JAButton("OK");
        JAButton btnCancel = new JAButton("Cancel");
        btnOK.addActionListener(new OkAction(this));
        btnCancel.addActionListener(new CancelAction(this));

        pnlDialogButtons.add(btnOK);
        pnlDialogButtons.add(btnCancel);
        pane.add(pnlDialogButtons, BorderLayout.SOUTH);

        setSize(400, 300);
        setLocationRelativeTo(null);
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing (WindowEvent e) {
                CancelAction cancelAction = new CancelAction((ManageCollectionGroupsDialog.this));
                cancelAction.actionPerformed(new ActionEvent(this, 0, ""));
            }
        });
    }

    private ArrayList getIncludedGroups () {
        ArrayList groups = new ArrayList();
        for (int i = 0; i < theCollection.getGroupCount(); i++) {
            groups.add(theCollection.getGroup(i));
        }

        return groups;
    }
    private ArrayList getAllGroups () {
        ArrayList allGroups = new ArrayList();
        MetaConstantGroup group = theEditor.theMetadataDispenser.getFirstMetaConstantGroup();
        while (group != null) {
            allGroups.add(group);
            group = group.theNextSibling;
        }

        return allGroups;
    }

    private Object[] getAllGroupNames () {
        ArrayList allGroupNames = new ArrayList();
        MetaConstantGroup group = theEditor.theMetadataDispenser.getFirstMetaConstantGroup();
        while (group != null) {
            allGroupNames.add(group.sClassName);
            group = group.theNextSibling;
        }

        return allGroupNames.toArray();
    }

    void populateDisplay () {
        // display all groups...
        ArrayList allGroups = getAllGroups();
        lstGroups.setListData(getAllGroupNames());

        ArrayList includedGroups = getIncludedGroups();
        int[] selectedIndices = new int[includedGroups.size()];

        // now select all the ones included in the collection already...
        for (int iSelectedGroup = 0; iSelectedGroup < includedGroups.size(); iSelectedGroup++) {
            selectedIndices[iSelectedGroup] = allGroups.indexOf(includedGroups.get(iSelectedGroup));
        }
        lstGroups.setSelectedIndices(selectedIndices);
    }


    class CancelAction implements ActionListener {
        private final ManageCollectionGroupsDialog dialog;

        public CancelAction (ManageCollectionGroupsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
            hide();
        }
    }


    class OkAction implements ActionListener {
        private final ManageCollectionGroupsDialog dialog;

        public OkAction (ManageCollectionGroupsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
            MetadataDispenser theMetadataDispenser = dialog.theEditor.theMetadataDispenser;
            theCollection.clearGroups();
            Object[] selectedGroupNames = lstGroups.getSelectedValues();
            for (int iSelectedGroup = 0; iSelectedGroup < selectedGroupNames.length; iSelectedGroup++) {
                String sSelectedGroupName = (String) selectedGroupNames[iSelectedGroup];
                theCollection.addGroup(theMetadataDispenser.findConstantGroup(sSelectedGroupName));
            }
            theEditor.setMetadataModified(true);
            dialog.hide();

        }
    }

}


