/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * EventListenerContainer.java
 *
 * Creator:
 * 08.09.2003 11:05:27 lauchenauer
 *
 * Maintainer:
 * 08.09.2003 11:05:27 lauchenauer
 *
 * Last Modification:
 * $Id: EventListenerContainer.java,v 1.12 2005/10/26 10:29:02 graeulich Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */
package ch.abacus.lib.ui;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/**
 * A container class to add and remove event listeners
 */
public class EventListenerContainer
{
    /**
     * The actual container for the listeners
     */
    protected Set<EventListener> mListenerList;


    public void clearListeners()
    {
        mListenerList.clear();
    }


    /**
     * Adds a EventListener to the internal listener list
     *
     * @param l the EventListener that is to be added
     */
    public void addListener(EventListener l)
    {
        if (mListenerList == null)
        {
            mListenerList = new HashSet<EventListener>();
        }
        if (!mListenerList.contains(l))
        {
            mListenerList.add(l);
        }
    }


    /**
     * Removes a EventListener from the internal listener list
     *
     * @param l the EventListener that is to be removed from the list
     */
    public void removeListener(EventListener l)
    {
        if (mListenerList != null && mListenerList.contains(l))
        {
            mListenerList.remove(l);
        }
    }


    /**
     * Returns the number of elements in this set (its cardinality).
     *
     * @return the number of elements in this set (its cardinality).
     */
    public int size()
    {
        return mListenerList.size();
    }


    /**
     * Returns an iterator over all the listeners
     *
     * @return an iterator over all listeners
     */
    public Iterator iterator()
    {
        if (mListenerList != null)
        {
            //gra: we make a copy because of synchronization issues. we cannot expect any one using this iterator synchronizing it himself
            return new ArrayList(mListenerList).iterator();
        }

        return new Iterator()
        {
            public void remove()
            {
            }


            public Object next() throws NoSuchElementException
            {
                return null;
            }


            public boolean hasNext()
            {
                return false;
            }
        };
    }

}
