/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.DefaultComboBoxModel;
import java.util.Vector;

/**
 *  Stub
 */

public class JAComboBox extends JComboBox {

  /**
   * Creates a <code>JComboBox</code> that takes it's items from an
   * existing <code>ComboBoxModel</code>.  Since the
   * <code>ComboBoxModel</code> is provided, a combo box created using
   * this constructor does not create a default combo box model and
   * may impact how the insert, remove and add methods behave.
   *
   * @param aModel the <code>ComboBoxModel</code> that provides the
   *    displayed list of items
   */
  public JAComboBox(ComboBoxModel aModel) {
    super(aModel);
  }

  /**
   * Creates a <code>JComboBox</code> that contains the elements
   * in the specified array.  By default the first item in the array
   * (and therefore the data model) becomes selected.
   *
   * @param items  an array of objects to insert into the combo box
   * @see DefaultComboBoxModel
   */
  public JAComboBox(final Object items[]) {
    super(items);
  }

  /**
   * Creates a <code>JComboBox</code> that contains the elements
   * in the specified Vector.  By default the first item in the vector
   * and therefore the data model) becomes selected.
   *
   * @param items  an array of vectors to insert into the combo box
   * @see DefaultComboBoxModel
   */
  public JAComboBox(Vector items) {
    super(items);
  }

  /**
   * Creates a <code>JComboBox</code> with a default data model.
   * The default data model is an empty list of objects.
   * Use <code>addItem</code> to add items.  By default the first item
   * in the data model becomes selected.
   *
   * @see DefaultComboBoxModel
   */
  public JAComboBox() {
    super();
  }

}
