package ch.abacus.lib.ui.plaf.generic;

/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */


import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;

import ch.abacus.lib.ui.JAComboBox;

/**
 * Based on code from @author Lauchenauer
 *
 * Edited/Moved to generic by open abacus team
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 */
public class GenericBorders {
  private static Border mTextFieldBorder;
  private static Border mHoveredTextFieldBorder;
  private static Border mLineBorder;
  private static Border mHoveredLineBorder;
  private static Border mComboBoxBorder;
  private static Border mButtonBorder;
  private static Border mHoveredButtonBorder;
  private static GenericBorders.ButtonBorder mHoverAbacusButtonBorder;
  private static Border mTableHeaderBorder;

  /**
   * Returns a border instance for a JTextField
   * @since 1.3
   */
  public static Border getTextFieldBorder() {
    if(mTextFieldBorder == null) {
//      mTextFieldBorder = new BorderUIResource.LineBorderUIResource(GenericLookAndFeel.getBorderNormal(), 1);
      mTextFieldBorder = new TextFieldBorder(GenericLookAndFeel.getBorderNormal(), 1);
    }
    return mTextFieldBorder;
  }

  public static Border getHoveredTextFieldBorder() {
    if(mHoveredTextFieldBorder == null) {
//      mHoveredTextFieldBorder = new BorderUIResource.LineBorderUIResource(GenericLookAndFeel.getSelectBorderColor(), 1);
      mHoveredTextFieldBorder = new TextFieldBorder(GenericLookAndFeel.getSelectBorderColor(), 1);
    }
    return mHoveredTextFieldBorder;
  }


  public static Border getLineBorder() {
    if(mLineBorder == null) {
      mLineBorder = new BorderUIResource.LineBorderUIResource(GenericLookAndFeel.getBorderNormal(), 1);
    }
    return mLineBorder;
  }

  public static Border getHoveredLineBorder() {
    if(mHoveredLineBorder == null) {
      mHoveredLineBorder = new BorderUIResource.LineBorderUIResource(GenericLookAndFeel.getSelectBorderColor(), 1);
    }
    return mHoveredLineBorder;
  }


  /**
   * Returns a border instance for a JComboBox Edit field
   * @deprecated no longer needed
   */
  public static Border getComboBoxBorder() {
    if(mComboBoxBorder == null) {
      mComboBoxBorder = new BorderUIResource.LineBorderUIResource(GenericLookAndFeel.getBorderNormal(), 2);
    }
    return mComboBoxBorder;
  }


  /**
   * get the progressbar border
   * @return Border for the progressbar
   */
  public static Border getProgressBarBorder() {
//    UIDefaults table = UIManager.getLookAndFeelDefaults();
    Border progressBarBorder = BorderFactory.createCompoundBorder (  BorderFactory.createLineBorder ( GenericLookAndFeel.getBorderNormal(), 1),
                                                                     BorderFactory.createEmptyBorder ( 1,1,1,1) );

           ;
    return progressBarBorder;
  }


  public static Border getTableHeaderBorder() {
    if(mTableHeaderBorder == null) {
//      mTableHeaderBorder = new AbstractBorder() { // this was the old way, but this paints no space to the beginning of field / 11.03.2005 PHE
      mTableHeaderBorder = new EmptyBorder(0, 2, 0, 0) {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
          g.setClip((int) g.getClipBounds().getX(), (int) g.getClipBounds().getY(), (int) g.getClipBounds().getWidth(), (int) g.getClipBounds().getHeight() + 1);
          g.setColor(GenericLookAndFeel.getWhite());
          g.drawLine(x, y, x + w - 1, y);           // top
          g.drawLine(x, y + h - 1, x, y + 1);         // left

          g.setColor(GenericLookAndFeel.getDarkGray());

          g.drawLine(x + 1, y + h, x + w - 1, y + h); // bottom
          g.drawLine(x + w - 1, y + h, x + w - 1, y + 1); // right
        }

        public Insets getBorderInsets(Component c) {
          return new Insets(1, 1, 1, 1);
        }
      };
    }
    return mTableHeaderBorder;
  }


  public static Border getButtonBorder() {
    if(mButtonBorder == null) {
      // use the default border stuff to paint the regular border, this border makes some insets with the margin
      mButtonBorder = new BorderUIResource.CompoundBorderUIResource(new GenericBorders.ButtonBorder(false), new BasicBorders.MarginBorder());  // orig metal
    }
    return mButtonBorder;
  }

  public static Border getHoveredButtonBorder(AbstractButton oldButton) {
    if(mHoveredButtonBorder == null) {
      // use tha abacus MarginBorder, the insets would not be changed like in the regular button, we give the insets as
      // parameter to the mHoverAbacusButtonBorder reference. this insets will be used instead. so it's possible that
      // the coder can change the insets and margins for a special button (see the menu or catalog buttons as sample)
      mHoverAbacusButtonBorder = new GenericBorders.ButtonBorder(true);
      mHoveredButtonBorder = new BorderUIResource.CompoundBorderUIResource(mHoverAbacusButtonBorder, new MarginBorder());
    }
    mHoverAbacusButtonBorder.setBorderInsets(oldButton.getInsets());
    return mHoveredButtonBorder;
  }


  public static class ButtonBorder extends AbstractBorder implements UIResource {

    protected Insets borderInsets = new Insets(3, 3, 3, 3);
    protected boolean mIsHovered;

    public ButtonBorder(boolean hovered) {
      mIsHovered = hovered;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
      AbstractButton button = (AbstractButton) c;
      ButtonModel model = button.getModel();
      if(model.isEnabled()) {
        if(model.isPressed() && model.isArmed()) {
          GenericUtils.drawPressedBorder(g, x, y, w, h, mIsHovered);
        } else {
          if((button instanceof JButton) && ((JButton) button).isDefaultButton()) {
            GenericUtils.drawDefaultButtonBorder(g, x, y, w, h, button.hasFocus() && false, mIsHovered);
          } else {
            GenericUtils.drawButtonBorder(g, x, y, w, h, button.hasFocus() && false, mIsHovered);
          }
        }
      } else { // disabled state
        GenericUtils.drawDisabledBorder(g, x, y, w - 1, h - 1);
      }
    }

    public void setBorderInsets(Insets insets) {
      borderInsets = insets;
    }

    public Insets getBorderInsets(Component c) {
      return borderInsets;
    }

    public Insets getBorderInsets(Component c, Insets newInsets) {
      return borderInsets;
    }
  }


  public static class MarginBorder extends AbstractBorder implements UIResource {
    public Insets getBorderInsets(Component c) {
      return getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component c, Insets insets) {
      return insets;
    }
  }


  public static class TextFieldBorder extends LineBorder {
    private final static Insets mInsets = new Insets(1, 3, 1, 2);

    public TextFieldBorder(Color color) {
      super(color);
    }

    public TextFieldBorder(Color color, int thickness) {
      super(color, thickness);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
      super.paintBorder(c, g, x, y, width, height);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
      if(c instanceof JAComboBox) {
        return super.getBorderInsets(c, insets);
      } else {
        return super.getBorderInsets(c, mInsets);
      }
    }

    public Insets getBorderInsets(Component c) {
      if(c instanceof JAComboBox) {
        return super.getBorderInsets(c);
      } else {
        return mInsets;
      }
    }
  }
}