/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.plaf.generic;

import ch.abacus.lib.images.ImageLoader;

import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;

import javax.swing.*;
import javax.swing.plaf.UIResource;

/**
 * Based on code from @author Lauchenauer
 *
 * Moved/Edited to generic brach by open source team
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 */
public class GenericIconFactory {
  private static Icon mCheckBoxIcon;
  private static Icon mFocusedCheckBoxIcon;
  private static Icon mRadioButtonIcon; 
  private static Icon mFocusedRadioButtonIcon;

  private static Icon mTreeLeafIcon;
  private static Icon mTreeOpenIcon;
  private static Icon mTreeClosedIcon;
  private static Icon mTreeExpandedIcon;
  private static Icon mTreeCollapsedIcon;

  private static Icon mErrorIcon;
  private static Icon mInformIcon;
  private static Icon mQuestionIcon;
  private static Icon mWarningIcon;


  public static Icon getCheckBoxIcon() {
    if (mCheckBoxIcon == null) {
      mCheckBoxIcon = new CheckBoxIcon();
    }
    return mCheckBoxIcon;
  }

  public static Icon getFocusedCheckBoxIcon() {
    if (mFocusedCheckBoxIcon == null) {
      mFocusedCheckBoxIcon = new FocusedCheckBoxIcon();
    }
    return mFocusedCheckBoxIcon;
  }


  public static Icon getRadioButtonIcon() {
    if(mRadioButtonIcon == null) {
      mRadioButtonIcon = new RadioButtonIcon();
    }
    return mRadioButtonIcon;
  }
  public static Icon getFocusedRadioButtonIcon() {
    if(mFocusedRadioButtonIcon == null) {
      mFocusedRadioButtonIcon = new FocusedRadioButtonIcon();
    }
    return mFocusedRadioButtonIcon;
  }

  public static Icon getTreeFolderIconOpen() {
      if ( mTreeOpenIcon == null ) {
          mTreeOpenIcon = new ImageIcon("lnf/tree_open.png");
      }
      return mTreeOpenIcon;
  }

    public static Icon getTreeFolderIconClosed() {
        if ( mTreeClosedIcon == null ) {
            mTreeClosedIcon = new ImageIcon( "lnf/tree_closed.png" );
        }
        return mTreeClosedIcon;
    }

    public static Icon getTreeLeafIcon() {
        if ( mTreeLeafIcon == null ) {
            mTreeLeafIcon = new ImageIcon( "lnf/tree_leaf.png" );
        }
        return mTreeLeafIcon;
    }

    public static Icon getTreeExpandedIcon() {
        if ( mTreeExpandedIcon == null ) {
            mTreeExpandedIcon = ImageLoader.getImageIcon( "lnf/tree_expanded.png" );
        }
        return mTreeExpandedIcon;
    }

    public static Icon getTreeCollapsedIcon() {
        if ( mTreeCollapsedIcon == null ) {
            mTreeCollapsedIcon = ImageLoader.getImageIcon( "lnf/tree_collapsed.png" );
        }
        return mTreeCollapsedIcon;
    }

    public static Icon getErrorIcon() {
        if ( mErrorIcon == null ) {
            mErrorIcon= ImageLoader.getImageIcon( "lnf/error.png" );
        }
        return mErrorIcon;
    }

    public static Icon getInformIcon() {
        if ( mInformIcon == null ) {
            mInformIcon= ImageLoader.getImageIcon( "lnf/inform.png" );
        }
        return mInformIcon;
    }

    public static Icon getQuestionIcon() {
        if ( mQuestionIcon == null ) {
            mQuestionIcon= ImageLoader.getImageIcon( "lnf/question.png" );
        }
        return mQuestionIcon;
    }

    public static Icon getWarningIcon() {
        if ( mWarningIcon == null ) {
            mWarningIcon= ImageLoader.getImageIcon( "lnf/warning.png" );
        }
        return mWarningIcon;
    }




  private static class CheckBoxIcon implements Icon, UIResource, Serializable {
    protected int getControlSize() { return 13; }
    
    public void paintIcon(Component c, Graphics g, int x, int y) {
//      JCheckBox cb = (JCheckBox) c;
      AbstractButton cb = (AbstractButton) c;
      ButtonModel model = cb.getModel();
      int controlSize = getControlSize();
  
      boolean drawCheck = model.isSelected();
  
      if(model.isEnabled()) {
        g.setColor(GenericLookAndFeel.getWhite());
        g.fillRect(x, y, controlSize - 1, controlSize - 1);
        g.setColor(GenericLookAndFeel.getBorderNormal());
        g.drawRect(x, y, controlSize - 1, controlSize -1);
        g.setColor(GenericLookAndFeel.getBlack());   // getControlInfo()
      } else {
        g.setColor(GenericLookAndFeel.getLightGray());
        g.fillRect(x, y, controlSize - 1, controlSize - 1);

        g.setColor(GenericLookAndFeel.getDarkGray());    // getControlShadow()
        g.drawRect(x, y, controlSize - 1, controlSize - 1);
      }
  
      if (model.isSelected()) {
        drawCheck(c, g, x, y);
      }
    }
  
    protected void drawCheck(Component c, Graphics g, int x, int y) {
      int controlSize = getControlSize();
      g.fillRect(x + 3, y + 5, 2, controlSize - 8);
      g.drawLine(x + (controlSize - 4), y + 3, x + 5, y + (controlSize - 6));
      g.drawLine(x + (controlSize - 4), y + 4, x + 5, y + (controlSize - 5));
    }
  
    public int getIconWidth() {
      return getControlSize();
    }
  
    public int getIconHeight() {
      return getControlSize();
    }
  } // End class CheckBoxIcon

  private static class FocusedCheckBoxIcon implements Icon, UIResource, Serializable {
    protected int getControlSize() { return 13; }
    
    public void paintIcon(Component c, Graphics g, int x, int y) {
      JCheckBox cb = (JCheckBox) c;
      ButtonModel model = cb.getModel();
      int controlSize = getControlSize();
  
      boolean drawCheck = model.isSelected();
  
      if (model.isEnabled()) {
        if (model.isPressed() && model.isArmed()) {
          g.setColor(GenericLookAndFeel.getFillDown());
          g.fillRect(x, y, controlSize - 1, controlSize - 1);
          g.setColor(GenericLookAndFeel.getSelectBorderColor());
          g.drawRect(x, y, controlSize - 1, controlSize - 1);
        } else {
          g.setColor(GenericLookAndFeel.getSelectColor());  // getWhite()
          g.fillRect(x, y, controlSize - 1, controlSize - 1);
          g.setColor(GenericLookAndFeel.getSelectBorderColor());
          g.drawRect(x, y, controlSize - 1, controlSize -1);
        }
        g.setColor(GenericLookAndFeel.getBlack());
      } else {
        g.setColor(GenericLookAndFeel.getDisabledColor());
        g.drawRect(x, y, controlSize - 1, controlSize - 1);
      }
  
      if(model.isSelected()) {
        drawCheck(c, g, x, y);
      }
    }
  
    protected void drawCheck(Component c, Graphics g, int x, int y) {
      int controlSize = getControlSize();
      g.fillRect(x + 3, y + 5, 2, controlSize - 8);
      g.drawLine(x + (controlSize - 4), y + 3, x + 5, y + (controlSize - 6));
      g.drawLine(x + (controlSize - 4), y + 4, x + 5, y + (controlSize - 5));
    }
  
    public int getIconWidth() {
      return getControlSize();
    }
  
    public int getIconHeight() {
      return getControlSize();
    }
  }



  // Radio button code
  private static class RadioButtonIcon implements Icon, UIResource, Serializable {
    public void paintIcon(Component c, Graphics g, int x, int y) {
      AbstractButton rb = (AbstractButton)c;
      ButtonModel model = rb.getModel();
      boolean drawDot = model.isSelected();

      g.translate(x, y);
      
      // fill interior
      if(drawDot) {
        g.setColor(GenericLookAndFeel.getSelectColor());
      } else {
        g.setColor(GenericLookAndFeel.getWhite());
      }
      g.fillRect(2,2, 9,9);
       
        // draw Dark Circle (start at top, go clockwise)      
      g.setColor(GenericLookAndFeel.getBorderNormal());
      g.drawLine( 4, 0,  7, 0);
      g.drawLine( 8, 1,  9, 1);
      g.drawLine(10, 2, 10, 3);
      g.drawLine(11, 4, 11, 7);
      g.drawLine(10, 8, 10, 9);
      g.drawLine( 9,10,  8,10);
      g.drawLine( 7,11,  4,11);
      g.drawLine( 3,10,  2,10);
      g.drawLine( 1, 9,  1, 8);
      g.drawLine( 0, 7,  0, 4);
      g.drawLine( 1, 3,  1, 2);
      g.drawLine( 2, 1,  3, 1);
      
      if(drawDot) {
        g.setColor(c.getForeground());
        g.fillRect(4, 4,  4, 4);
        g.drawLine(4, 3,  7, 3);
        g.drawLine(8, 4,  8, 7);
        g.drawLine(7, 8,  4, 8);
        g.drawLine(3, 7,  3, 4);
      }
      
      g.translate(-x, -y);
    }

    public int getIconWidth() {
      return 13;
    }

    public int getIconHeight() {
      return 13;
    }
  }  // End RadioButtonIcon

  private static class FocusedRadioButtonIcon extends RadioButtonIcon implements Icon, UIResource, Serializable {
    public void paintIcon(Component c, Graphics g, int x, int y) {
      AbstractButton rb = (AbstractButton)c;
//      JRadioButton rb = (JRadioButton)c;
      ButtonModel model = rb.getModel();
      boolean drawDot = model.isSelected();

      g.translate(x, y);
      // fill interior
      g.setColor(GenericLookAndFeel.getSelectColor());
      g.fillRect(2,2, 9,9);
        // draw Dark Circle (start at top, go clockwise)
      g.setColor(GenericLookAndFeel.getSelectBorderColor());
      g.drawLine( 4, 0,  7, 0);
      g.drawLine( 8, 1,  9, 1);
      g.drawLine(10, 2, 10, 3);
      g.drawLine(11, 4, 11, 7);
      g.drawLine(10, 8, 10, 9);
      g.drawLine( 9,10,  8,10);
      g.drawLine( 7,11,  4,11);
      g.drawLine( 3,10,  2,10);
      g.drawLine( 1, 9,  1, 8);
      g.drawLine( 0, 7,  0, 4);
      g.drawLine( 1, 3,  1, 2);
      g.drawLine( 2, 1,  3, 1);
      // selected dot
      if(drawDot) {
        g.setColor(c.getForeground());
        g.fillRect( 4, 4,  4, 4);
        g.drawLine( 4, 3,  7, 3);
        g.drawLine( 8, 4,  8, 7);
        g.drawLine( 7, 8,  4, 8);
        g.drawLine( 3, 7,  3, 4);
      }
      
      g.translate(-x, -y);
    }
  }
  
}