package ch.abacus.lib.ui.plaf.generic;
/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

import java.awt.Component;
import java.awt.Graphics;

import javax.swing.UIManager;

/**
 * util class
 * Created on 09.08.2002
 * Based on code fomr @author hemmer
 * 
 * March 25th 2005 Moved/Edit to generic branch by open abacus team
 * Copyright (c) 2001-2002 ABACUS Research AG All Rights Reserved.
 */
public class GenericUtils {


  static void drawFlushBorder(Graphics g, int x, int y, int w, int h) {
    g.translate(x, y);
    g.drawRect(0, 0, w - 1, h - 1);   // tl
    g.translate(-x, -y);
  }

  static void drawDisabledBorder(Graphics g, int x, int y, int w, int h) {
    g.translate(x, y);
    g.setColor(GenericLookAndFeel.getDisabledColor());
//    g.drawRect(0, 0, w - 1, h - 1); // tl
    g.drawRect(0, 0, w, h );
  }

  /**
    * This draws a variant "Flush Border"
    * It is used for things like pressed buttons.
    */
  static void drawPressedBorder(Graphics g, int x, int y, int w, int h, boolean isFocused) {
    if(isFocused) {
      g.setColor(GenericLookAndFeel.getSelectBorderColor());
    } else {
      g.setColor(GenericLookAndFeel.getBorderNormal());
    }
    g.translate(x, y);
    drawFlushBorder(g, 0, 0, w, h);
    g.translate(-x, -y);

  }

  static void drawButtonBorder(Graphics g, int x,  int y, int w, int h, boolean active, boolean isFocused) {
    if(active) {
      drawActiveButtonBorder(g, x, y, w, h);
    } else {
      if(isFocused) {
        g.setColor(GenericLookAndFeel.getSelectBorderColor());
      } else {
        g.setColor(GenericLookAndFeel.getBorderNormal());
      }
      drawFlushBorder(g, x, y, w, h);
    }
  }
  static void drawActiveButtonBorder(Graphics g, int x, int y, int w, int h) {
    g.setColor(GenericLookAndFeel.getSelectBorderColor());
    drawFlushBorder(g, x, y, w, h);
  }
  static void drawDefaultButtonBorder(Graphics g, int x, int y, int w, int h, boolean active, boolean isFocused) {
    drawButtonBorder(g, x + 1, y + 1, w - 1, h - 1, active, isFocused);
    if(isFocused) {
      g.setColor(GenericLookAndFeel.getSelectBorderColor());
    } else {
      g.setColor(GenericLookAndFeel.getBorderNormal());
    }
    g.drawRect(x, y, w - 1, h - 1);
    g.drawRect(x, y, w - 2, h - 2);
    g.drawLine(w - 1, 0, w - 1, 0);
    g.drawLine(0, h - 1, 0, h - 1);
  }
  
 
  
  
  
  
  /*
   * Convenience function for determining ComponentOrientation.  Helps us
   * avoid having Munge directives throughout the code.
   */
  static boolean isLeftToRight(Component c) {
    return c.getComponentOrientation().isLeftToRight();
  }
  static int getInt(Object key, int defaultValue) {
    Object value = UIManager.get(key);
    if (value instanceof Integer) {
      return ((Integer) value).intValue();
    }
    if (value instanceof String) {
      try {
        return Integer.parseInt((String) value);
      } catch (NumberFormatException nfe) {
      }
    }
    return defaultValue;
  }
}
