/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 19.04.2005 10:21:57 Misteli
 *
 * Maintainer:
 * 19.04.2005 10:21:57 Misteli
 *
 * Last Modification:
 * $Id: GroupEditorInterface.java,v 1.1 2005/09/02 14:26:04 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.core;

import java.awt.event.MouseEvent;

/**
 * A GroupEditorInterface can be used to implement an editor for all properties of the group it belongs to. For example,
 * a physical Font property would be separate Properties for Font name, size and boolean properties for the style. The
 * GroupEditorInterface could be used to implement a Font Editor that can modify all font properties at once using a Font Dialog.
 * As soon as a Group contains a GroupEditorInterface, the group itself will be display with a little group button which,
 * when pressed invoked the edit method..
 */
public interface GroupEditorInterface extends EditorInterface {

  /**
   * Is called when the user presses the group editor button.
   * @param e The mouse event where it occured..
   * @param group the Group it was invoked for
   */
  public void edit(MouseEvent e, Group group);

  /**
   * returns the string that appears over the icon
   * @return
   */
  public String getHint();

  public boolean isVisible(Group group);
}
