/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 19.04.2005 13:42:59 Misteli
 *
 * Maintainer:
 * 19.04.2005 13:42:59 Misteli
 *
 * Last Modification:
 * $Id: PropertyInspectorCellEditor.java,v 1.5 2005/10/07 12:16:41 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display.editor;

import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.propertyinspector.display.DisplayProperty;
import ch.abacus.lib.ui.propertyinspector.display.PropertyValueEditorInterface;

import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.JComponent;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import java.awt.Component;
import java.util.EventObject;

public class PropertyInspectorCellEditor extends AbstractCellEditor implements TableCellEditor {

  private PropertyValueEditorInterface currentEditor;
  private JTable table;
  private JALabel label = new JALabel();

  public PropertyInspectorCellEditor(JTable table) {
    super();
    this.table = table;
  }

  public void cancelCellEditing() {
    if (currentEditor != null)
      currentEditor.cancelCellEditing();
    super.cancelCellEditing();
  }

  public boolean stopCellEditing() {
    if (currentEditor != null)
      return currentEditor.stopCellEditing();
    return super.stopCellEditing();
  }

  public PropertyValueEditorInterface getCurrentEditor() {
    return currentEditor;
  }

  public Object getCellEditorValue() {
    return currentEditor.getCellEditorValue();
  }

  public boolean isCellEditable(EventObject anEvent) {
    return true;
  }

  public boolean shouldSelectCell(EventObject anEvent) {
    return currentEditor.shouldSelectCell(anEvent);
  }

  public void addCellEditorListener(CellEditorListener l) {
    super.addCellEditorListener(l);
    currentEditor.addCellEditorListener(l);
  }

  public void removeCellEditorListener(CellEditorListener l) {
    super.removeCellEditorListener(l);
    currentEditor.removeCellEditorListener(l);
  }

  public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
    table.getSelectionModel().setSelectionInterval(row, row);
    DisplayProperty property = (DisplayProperty) value;
    currentEditor = property.getProperty().getEditor();
    if (currentEditor == null)
      return label;
    else {
      Component c = currentEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
      currentEditor.setValueEditorReadOnly(property.getProperty().isValueEditorReadOnly());
      c.requestFocus();
      return c;
//      final Component c = currentEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
//      currentEditor.setValueEditorReadOnly(property.getProperty().isValueEditorReadOnly());
//      SwingUtilities.invokeLater(new Runnable() {
//        public void run() {
//          System.out.println("currentEditor: " + currentEditor);
//          c.requestFocus();
//        }
//      });
//      return c;
    }
  }
}
