/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 19.04.2005 10:24:16 Misteli
 *
 * Maintainer:
 * 19.04.2005 10:24:16 Misteli
 *
 * Last Modification:
 * $Id: IconLabel.java,v 1.2 2005/09/02 14:35:39 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display.renderer;

import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.report.preview.PreviewPanel;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;

public class IconLabel extends PreviewPanel {

  private JALabel label = new JALabel();
  private JALabel button = new JALabel();
  private String hint = null;

  private Color color = UIManager.getColor("Panel.background").darker();

  private Border lineBorder = new Border() {
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
      Color aColor = g.getColor();
      try {
        g.setColor(color);
        g.drawLine(x, y, x, y + height);
      }
      finally {
        g.setColor(aColor);
      }
    }

    public Insets getBorderInsets(Component c) {
      return new Insets(0, 2, 0, 0);
    }

    public boolean isBorderOpaque() {
      return true;
    }
  };

  public IconLabel() {
    super();
    setLayout(new BorderLayout());
    add(label, BorderLayout.CENTER);
    add(button, BorderLayout.EAST);
    button.setVisible(false);
    button.setPreferredSize(new Dimension(16, 16));
    button.setBorder(lineBorder);
    setOpaque(true);
  }

  public String getToolTipText(MouseEvent event) {
    if (isButton(event.getX(), event.getY()) && hint != null)
      return hint;
    return super.getToolTipText(event);
  }

  private boolean isButton(int x, int y) {
    return x >= button.getX() && x <= button.getX() + button.getWidth() &&
           y >= button.getY() && y <= button.getY() + button.getHeight();
  }

  public JLabel getButton() {
    return button;
  }

  public void setHint(String hint) {
    this.hint = hint;
  }

  public void setIcon(Icon icon) {
    button.setIcon(icon);
    button.setVisible(icon != null);
  }

  public void setBackground(Color c) {
    super.setBackground(c);
    if (label != null)
      label.setBackground(c);
  }

  public void setForeground(Color c) {
    super.setForeground(c);
    if (label != null)
      label.setForeground(c);
  }

  public void setFont(Font f) {
    super.setFont(f);
    if (label != null)
      label.setFont(f);
  }

  public void setText(String s) {
    if (label != null)
      label.setText(s);
  }

}
