/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 18.04.2005 15:56:43 Misteli
 *
 * Maintainer:
 * 18.04.2005 15:56:43 Misteli
 *
 * Last Modification:
 * $Id: PropertyValueRenderer.java,v 1.1 2005/09/02 14:26:06 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display.renderer;

import ch.abacus.lib.ui.propertyinspector.display.DisplayProperty;

import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

public abstract class PropertyValueRenderer extends BaseCellRenderer {

  private Border lineBorder = new Border() {
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {  }
    public Insets getBorderInsets(Component c) { return new Insets(0, 2, 0, 0); }
    public boolean isBorderOpaque() { return true; }
  };

  public abstract JComponent getComponent();
  public abstract void setValue(Object value);

  public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
    JComponent component = getComponent();
    component.setBorder(lineBorder);
    initialize(component, table, isSelected, hasFocus, row, column);
    DisplayProperty displayProperty = (DisplayProperty) value;
    if (!displayProperty.getValues().isSame())
      setValue(null);
    else {
      component.setFont(font);
      setValue(displayProperty.getValues().get(0));
    }
   return component;
  }

}
