/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.abaRenderer;

import ch.abacus.lib.ui.renderer.common.*;
import ch.abacus.lib.ui.renderer.droplets.DropletSimpleLog;

/**
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: 22.11.2003
 * Time: 23:22:04
 * To change this template use Options | File Templates.
 */

public class StaticRendererData {

    static StaticRendererData theStaticData;

    MetadataDispenser theMetadataDispenser;
    HammerConfigurationManager theConfigurationManager;

    // put the static data in the renderer, theFakeRenderer.
    AbaRenderer theFakeRenderer;
    private static ClassLoader savedClassLoader;

    public StaticRendererData(AbaRenderer theRenderer,
                                     DropletSimpleLog theLog, String sBaseDir, String sUserHome,
                                     HammerClassLoader theLoader, String sConfigurationPath) throws HammerException {
        // TheLog - Special for droplets.
        // This is just for basic loading debugging where
        // things can go wrong before you get access to
        // even the xml document with configuration settings.
        if (theLog == null) {
            if (theRenderer.getDropletsState()) {
                theLog = new DropletSimpleLog();
            }
        }
        if (theLog!=null)
            theLog.writeMessage("Inside metadata access constructor.  Log was null.");

        // Need initialization for each shared object.
        if (theFakeRenderer == null) {
            if (theLog!=null)
                theLog.writeMessage("Create fake renderer.");
            theFakeRenderer = theRenderer.makeFakeRenderer();
            theConfigurationManager = theFakeRenderer.theConfigurationManager;
        }
        if (theConfigurationManager == null) {
            if (theLog!=null)
                theLog.writeMessage("Call configuration manager");
            theConfigurationManager = new HammerConfigurationManager(sBaseDir, sUserHome, theLoader, sConfigurationPath);
        }
        if (theLog!=null)
            theLog.writeMessage("Sharing the configuration manager.");
        if (theMetadataDispenser == null) {
            theMetadataDispenser = new MetadataDispenser(theFakeRenderer, theFakeRenderer.theGlobalInterface, MetaObject.EXECUTION_MODE);
            theFakeRenderer.theMetadataDispenser = theMetadataDispenser;
        }

        // Load the metadata.
        boolean bTest = false;
        String SystemDocumentPath;
        SystemDocumentPath = theFakeRenderer.getSystemConfigurationPathName() + theFakeRenderer.getSystemMetadataDocumentName();
        if (theLog!=null)
            theLog.writeMessage("Inside metadata access constructor.  Log was null.");
        if (SystemDocumentPath == null)
            SystemDocumentPath = "metadata.meta";
        bTest = theMetadataDispenser.theMetadataDocument.loadMeta(theLog, SystemDocumentPath);
        if (theLog!=null)
            theLog.writeMessage("Ok all done with abarenderermetadataaccess constructor.  Result is "+(new Boolean(bTest)).toString());
    }

    public StaticRendererData(AbaRenderer theRenderer,
                                     String sBaseDir,
                                     String sUserHome,
                                     HammerClassLoader theLoader,
                                     String sConfigurationPath) throws HammerException {
        this(theRenderer, null, sBaseDir, sUserHome, theLoader, sConfigurationPath);
    }

    public static MetadataDispenser getMetadataDispenser() {
        return theStaticData.theMetadataDispenser;
    }

    public static void removeMetadata() {
        theStaticData.theMetadataDispenser = null;
        if (theStaticData.theFakeRenderer!=null) {
            theStaticData.theFakeRenderer.theClassLoader.setUser(null);
            theStaticData.theFakeRenderer.theLogFile.setUser(null);
            theStaticData.theFakeRenderer.theClassLoader = null;
            theStaticData.theFakeRenderer.theLogFile = null;
            theStaticData.theFakeRenderer.theMetadataDispenser = null;
        }
        theStaticData.theFakeRenderer = null;
        theStaticData.theConfigurationManager = null;
    }

    public HammerConfigurationManager getConfigurationManager() {
        return theConfigurationManager;
    }

    public static AbaRenderer getFakeRenderer() {
        return theStaticData.theFakeRenderer;
    }

    public static StaticRendererData getStaticData() {
        return theStaticData;
    }

    public static void setStaticData(StaticRendererData theStaticData) {
        StaticRendererData.theStaticData = theStaticData;
    }


    public static void setSavedClassLoader(ClassLoader theSavedClassLoader) {
        StaticRendererData.savedClassLoader = theSavedClassLoader;
    }

    public static ClassLoader getSavedClassLoader() {
        return StaticRendererData.savedClassLoader;
    }
}
