/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;


import java.io.*;
import java.util.zip.GZIPInputStream;
import java.util.ArrayList;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: Jun 9, 2003
 * Time: 9:17:04 AM
 * To change this template use Options | File Templates.
 */

public class AbaNLS {
    AbaNLSDocument firstDocument;
    AbaNLSDocument lastDocument;
    int theDocumentCount;
    MetaProject theProject;

    public AbaNLS(MetaProject theProject) {
        theDocumentCount = 0;
        this.theProject = theProject;
    }

    public void clear() {
        AbaNLSDocument document = firstDocument;
        while (document != null) {
            document = document.nextDocument;
            if (document != null)
                document.prevDocument = null;
        }
        firstDocument = null;
        lastDocument = null;
        theDocumentCount = 0;
    }

    public boolean addDocument(String sDocumentName, String sDocumentKey) {
        if ((theProject.getMetaDataUser().getLogFile() != null) && (theProject.getMetaDataUser().getLogFile().isNLSLogging())) {
            theProject.getMetaDataUser().getLogFile().doLogEntry("NLS AddDocument:  Will try to add Key = " + sDocumentKey + ", Name: " + sDocumentName, "");
        }
        try {
            HammerInputStream hfin = theProject.getMetaDataUser().getFileManager().getInputStream(sDocumentName);
            BufferedInputStream inputStream;
            if (hfin == null) {
                hfin = theProject.getMetaDataUser().getFileManager().getInputStream(theProject.getMetaDataUser().getSystemConfigurationPathName() + sDocumentName);
            }
            if (hfin == null)
                return false;

            InputStream fin = hfin.theStream;
            if (fin == null)
                return false;
            if (sDocumentName.endsWith("nlz")) {
                GZIPInputStream fzip = new GZIPInputStream(fin);
                inputStream = new BufferedInputStream(fzip);
            } else {
                inputStream = new BufferedInputStream(fin);
            }

            //   Load it as an XML document.

            electric.xml.Document xmlDocument = new electric.xml.Document(inputStream);
            electric.xml.Element xmlRoot = xmlDocument.getRoot();
            if (xmlRoot != null) {
                AbaNLSDocument theNewDocument = new AbaNLSDocument(sDocumentName, sDocumentKey, xmlDocument, xmlRoot, new Boolean(false));
                addNLSDocument(theNewDocument);
                theDocumentCount++;
                return true;
            }

        } catch (electric.xml.ParseException e1) {
            if ((theProject.getMetaDataUser().getLogFile() != null) && (theProject.getMetaDataUser().getLogFile().isNLSLogging())) {
                theProject.getMetaDataUser().getLogFile().doLogEntry("NLS AddDocument:  Key = " + sDocumentKey + ", Name: " + sDocumentName, " Failed to load. Parse Error.");
            }
        } catch (java.io.FileNotFoundException e2) {
            if ((theProject.getMetaDataUser().getLogFile() != null) && (theProject.getMetaDataUser().getLogFile().isNLSLogging())) {
                theProject.getMetaDataUser().getLogFile().doLogEntry("NLS AddDocument:  Key = " + sDocumentKey + ", Name: " + sDocumentName, " Failed to load. Document not found.");
            }
        } catch (java.io.IOException e3) {
            if ((theProject.getMetaDataUser().getLogFile() != null) && (theProject.getMetaDataUser().getLogFile().isNLSLogging())) {
                theProject.getMetaDataUser().getLogFile().doLogEntry("NLS AddDocument:  Key = " + sDocumentKey + ", Name: " + sDocumentName, " Failed to load. IO Error.");
            }
        }
        return false; // xml root not defined for document - bad!
    }

    public void addNLSDocument(AbaNLSDocument theNewDocument) {
        if (firstDocument == null) {
            firstDocument = theNewDocument;
            lastDocument = theNewDocument;
        } else {
            AbaNLSDocument doc = firstDocument;
            AbaNLSDocument prevDoc = null;
            AbaNLSDocument nextDoc = null;
            while (doc != null) {
                int iCompare = doc.theDocumentKey.compareTo(theNewDocument.theDocumentKey);
                if (iCompare < 0)
                    prevDoc = doc;  // will have the last that is smaller.
                else {
                    nextDoc = doc;  // will have the first that is bigger.
                    break;
                }
                doc = doc.nextDocument;
            }
            if (nextDoc != null) {
                nextDoc.prevDocument = theNewDocument;
                theNewDocument.nextDocument = nextDoc;
            } else { // add to end.
                lastDocument.nextDocument = theNewDocument;
                lastDocument = theNewDocument;
            }
            if (prevDoc != null) {
                theNewDocument.prevDocument = prevDoc;
                prevDoc.nextDocument = theNewDocument;
            } else {
                firstDocument.prevDocument = theNewDocument;
                firstDocument = theNewDocument;
            }
        }
    }

    public void removeNLSDocument(AbaNLSDocument theDocument) {

        if (firstDocument.equals(theDocument))
            firstDocument = theDocument.nextDocument;
        else {
            if (theDocument.nextDocument != null)
                theDocument.nextDocument.prevDocument = theDocument.prevDocument;
        }
        if (lastDocument.equals(theDocument))
            lastDocument = theDocument.prevDocument;
        else {
            if (theDocument.prevDocument != null)
                theDocument.prevDocument.nextDocument = theDocument.nextDocument;
        }

    }

    public AbaNLSDocument findNLSDocumentByKey(String sDocumentKey) {
        AbaNLSDocument doc = firstDocument;
        while (doc != null) {
            if (doc.theDocumentKey.equals(sDocumentKey))
                return doc;
            doc = doc.nextDocument;
        }
        return null;
    }

    public AbaNLSDocument findNLSDocumentByName(String sDocumentName) {
        AbaNLSDocument doc = firstDocument;
        while (doc != null) {
            if (doc.theDocumentName.equals(sDocumentName))
                return doc;
            doc = doc.nextDocument;
        }
        return null;
    }

    public AbaNLSDocument getNLSDocumentByIndex(int i) {
        int iDocument = 0;
        AbaNLSDocument doc = firstDocument;
        while (doc != null) {
            if (iDocument++ == i)
                return doc;
            doc = doc.nextDocument;
        }
        return null;
    }

    public electric.xml.Document getAbaNLSDocument(int i) {
        return getNLSDocumentByIndex(i).getDocument();
    }

    public electric.xml.Element getAbaNLSDocumentRootElement(int i) {
        return getNLSDocumentByIndex(i).getRootElement();
    }

    public int getAbaNLSDocumentByKey(String sKey) {
        if (sKey == null)
            return -1;
        AbaNLSDocument doc = firstDocument;
        int i = 0;
        while (doc != null) {
            if (doc.theDocumentKey.equals(sKey))
                return i;
            i++;
            doc = doc.nextDocument;
        }
        return -1;
    }

    public int getAbaNLSDocumentByName(String sName) {
        if (sName == null)
            return -1;
        AbaNLSDocument doc = firstDocument;
        int i = 0;
        while (doc != null) {
            if (doc.theDocumentName.equals(sName))
                return i;
            i++;
            doc = doc.nextDocument;
        }
        return -1;
    }

    public electric.xml.Element getValueElement(int iDocument, String sValueKey) {
        electric.xml.Element xmlRootElement = getAbaNLSDocumentRootElement(iDocument);
        if (xmlRootElement != null) {
            String sSearchString = "TEXT[@key=\"" + sValueKey + "\"]";
            electric.xml.XPath thePath = new electric.xml.XPath(sSearchString);
            electric.xml.Element theElement = xmlRootElement.getElement(thePath);
            return theElement;
        }
        return null;
    }

    public String getAbaNLSValue(String sDocumentKey, String sValueKey, boolean bMnemonic) {
        if ((theProject.getMetaDataUser().getLogFile() != null) && (theProject.getMetaDataUser().getLogFile().isNLSLogging())) {
            theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getAbaNLSValue - Document key: " + sDocumentKey + ", Value key:" + sValueKey, " Mnemonic: " + bMnemonic);
        }
        int iDocument = getAbaNLSDocumentByKey(sDocumentKey);
        if (iDocument > -1) {
            if ((theProject.getMetaDataUser().getLogFile() != null) && (theProject.getMetaDataUser().getLogFile().isNLSLogging())) {
                theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getAbaNLSValue - Document found ", "");
            }
            electric.xml.Element theMatchingElement = getValueElement(iDocument, sValueKey);
            if (bMnemonic) {
                String sMnemonic = theMatchingElement.getAttribute("mnemonic");
                if (sMnemonic == null)
                    sMnemonic = new String("\0");
                else if ((theProject.getMetaDataUser().getLogFile() != null) && (theProject.getMetaDataUser().getLogFile().isNLSLogging())) {
                    theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getAbaNLSValue, Mnemonic found ", sMnemonic);
                }
                return sMnemonic;
            }
            if (theMatchingElement != null) {
                String sRetVal = theMatchingElement.getTextString();
                if ((theProject.getMetaDataUser().getLogFile() != null) && (theProject.getMetaDataUser().getLogFile().isNLSLogging())) {
                    theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getAbaNLSValue, Value found ", sRetVal);
                }
                return sRetVal;
            }
        }
        return null;
    }

    public electric.xml.Element getRootElement(String sDocumentKey) {
        int iDocument = getAbaNLSDocumentByKey(sDocumentKey);
        if (iDocument > -1)
            return getAbaNLSDocumentRootElement(iDocument);
        else
            return null;
    }

    public electric.xml.Element getAbaNLSElement(String sDocumentKey, String sValueKey) {
        int iDocument = getAbaNLSDocumentByKey(sDocumentKey);
        if (iDocument > -1)
            return getValueElement(iDocument, sValueKey);
        return null;
    }

    public boolean addAbaNLSValue(String sDocumentKey, String sKeyName, String sKeyValue) {
        electric.xml.Element theNewElement = new electric.xml.Element("TEXT");
        if (theNewElement != null) {
            electric.xml.Element theRootElement = getRootElement(sDocumentKey);
            if (theRootElement != null) {
                electric.xml.Attribute theAttribute = new electric.xml.Attribute("key", sKeyValue);
                if (theAttribute != null) {
                    theNewElement = theNewElement.setAttribute(theAttribute);
                    theRootElement.addElement(theNewElement);
                    theNewElement.setText(sKeyValue);
                    return true;
                }

            }

        }
        return false;
    }

    public boolean changeAbaNLSValue(String sDocumentKey, String sValueKey, String sValue) {
        AbaNLSDocument theDocument = findNLSDocumentByKey(sDocumentKey);
        electric.xml.Element theElement = getAbaNLSElement(sDocumentKey, sValueKey);
        if (theElement != null) {
            theDocument.setChangeFlag(Boolean.TRUE);
            theElement.setText(sValue);
            return true;
        } else
            return false;
    }

    public boolean changeAbaNLSMnemonic(String sDocumentKey, String sValueKey, String sMnemonicValue) {
        AbaNLSDocument theDocument = findNLSDocumentByKey(sDocumentKey);
        electric.xml.Element theElement = getAbaNLSElement(sDocumentKey, sValueKey);
        if (theElement != null) {
            theDocument.setChangeFlag(Boolean.TRUE);
            theElement.setAttribute("mnemonic", sMnemonicValue);
            return true;
        } else
            return false;
    }

    public boolean removeAbaNLSValue(String sDocumentKey, String sValueKey) {
        electric.xml.Element theElement = getAbaNLSElement(sDocumentKey, sValueKey);
        if (theElement != null) {
            electric.xml.Element theRootElement = getRootElement(sDocumentKey);
            if (theRootElement != null) {
                theRootElement.removeChild(theElement);
                return true;
            }
        }
        return false;
    }

    public boolean writeNlsDocument(int iDocument) {
        AbaNLSDocument theNLSDocument = getNLSDocumentByIndex(iDocument);
        try {
            File fileOutput = new File(theNLSDocument.getDocumentName());
            if ((theProject.getMetaDataUser().getLogFile() != null) && (theProject.getMetaDataUser().getLogFile().isNLSLogging())) {
                theProject.getMetaDataUser().getLogFile().doLogEntry("NLS writeNLSDocument:  Will try to write = " + theNLSDocument.getDocumentName(), "");
            }
            PrintWriter pwOutput = new PrintWriter(new FileWriter(fileOutput));
            electric.xml.Document theDocument = theNLSDocument.getDocument();
            // Write the document.
            theDocument.write(pwOutput);
            pwOutput.close();
            if ((theProject.getMetaDataUser().getLogFile() != null) && (theProject.getMetaDataUser().getLogFile().isNLSLogging())) {
                theProject.getMetaDataUser().getLogFile().doLogEntry("NLS writeNLSDocument:  " + theNLSDocument.getDocumentName() + " successfully written", "");
            }

        } catch (java.io.IOException e) {
            if ((theProject.getMetaDataUser().getLogFile() != null) && (theProject.getMetaDataUser().getLogFile().isNLSLogging())) {
                theProject.getMetaDataUser().getLogFile().doLogEntry("NLS writeNLSDocument:  " + theNLSDocument.getDocumentName() + " Failure", "");
            }
            return false;
        }
        return true;
    }


    public boolean writeAllChangedNlsDocuments() {
        boolean bRetVal = true;
        for (int i = 0; i < theDocumentCount; i++) {
            AbaNLSDocument theDocument = getNLSDocumentByIndex(i);
            Boolean bTestValue = theDocument.getChangeFlag();
            if (bTestValue.booleanValue()) {
                boolean bTestWrite = writeNlsDocument(i);
                if (!bTestWrite)
                    bRetVal = false;
            }
        }
        return bRetVal;
    }

    /**
     * getDocumentKey
     * @param sKey - String of format @AbaNLS.DocKey.ValueKey
     * @param iLanguagePresentation - language to be used.
     * @param bMnemonic - translate mnemonic
     * @return
     */
    public String getTranslatedValue(String sKey, int iLanguagePresentation, boolean bMnemonic) {
        if (sKey.startsWith("@AbaNLS")) {
            if ((theProject.getMetaDataUser().getLogFile() != null) && (theProject.getMetaDataUser().getLogFile().isNLSLogging())) {
                theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getTranslatedValue:  " + sKey + ". Language is " + HammerLanguagePresentation.getLanguageName(iLanguagePresentation), "");
            }
            int iFirstDot = sKey.indexOf(".");
            int iLastDot = sKey.lastIndexOf(".");
            // Exception processing - not enough dots.
            if ((iFirstDot == -1) || (iFirstDot == iLastDot))
                return sKey;
            // Parse the pieces.
            String sDocumentKey = sKey.substring(iFirstDot + 1, iLastDot);
            String sSearchKey = sKey.substring(iLastDot + 1);
            String sDefaultDocumentKey = sDocumentKey + "_DE";
            // Add the language suffixes to the key.
            switch (iLanguagePresentation) {
                case HammerLanguagePresentation.DEUTSCH:
                    {
                        sDocumentKey = sDocumentKey + "_DE";
                        break;
                    }
                case HammerLanguagePresentation.FRANCAIS:
                    {
                        sDocumentKey = sDocumentKey + "_FR";
                        break;
                    }
                case HammerLanguagePresentation.ITALIAN:
                    {
                        sDocumentKey = sDocumentKey + "_IT";
                        break;
                    }
                case HammerLanguagePresentation.ENGLISH:
                    {
                        sDocumentKey = sDocumentKey + "_EN";
                        break;
                    }
                default:
                    {
                        sDocumentKey = sDocumentKey + "_DE";
                        break;
                    }
            }
            if ((theProject.getMetaDataUser().getLogFile() != null) && (theProject.getMetaDataUser().getLogFile().isNLSLogging())) {
                theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getTranslatedValue:  Searching for document with key: " + sDocumentKey, "");
                theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getTranslatedValue:  Searching for value with key: " + sSearchKey, "");
            }
            // Get the value from the appropriate xml document and return it.
            sKey = getAbaNLSValue(sDocumentKey, sSearchKey, bMnemonic);
            if ((sKey == null) && (iLanguagePresentation != HammerLanguagePresentation.DEFAULT)) {
                if ((theProject.getMetaDataUser().getLogFile() != null) && (theProject.getMetaDataUser().getLogFile().isNLSLogging())) {
                    theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getTranslatedValue:  Didn't find match.  Trying deutsch: " + sDefaultDocumentKey, "");
                    theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getTranslatedValue:  Didn't find match.  Trying deutsch: " + sSearchKey, "");
                }
                sKey = getAbaNLSValue(sDefaultDocumentKey, sSearchKey, bMnemonic);
            }
            if ((theProject.getMetaDataUser().getLogFile() != null) && (theProject.getMetaDataUser().getLogFile().isNLSLogging())) {
                theProject.getMetaDataUser().getLogFile().doLogEntry("NLS getTranslatedValue:  Return value: " + sKey, "");
            }
        }
        return sKey;
    }


    public int getDocumentCount() {
        return this.theDocumentCount;
    }

    public void Load() {
        clear();
        if ((theProject.getMetaDataUser().getLogFile() != null) && (theProject.getMetaDataUser().getLogFile().isNLSLogging())) {
            theProject.getMetaDataUser().getLogFile().doLogEntry("NLS Load was invoked!", "");
        }
        HammerConfigurationManager theConfigManager;
        theConfigManager = this.theProject.getMetaDataUser().getConfigurationManager();
        int iDocCount = theConfigManager.getNLSDocCount();
        for (int i = 0; i < iDocCount; i++) {
            String sKey = theConfigManager.getNLSDocKey(i);
            String sDoc = theConfigManager.getNLSDocName(i);
            if (findNLSDocumentByName(sKey) == null)
                this.addDocument(sDoc, sKey);
        }
        if (theProject.theLocalNLSDocuments != null) {
            iDocCount = theProject.theLocalNLSDocuments.size();
            for (int i = 0; i < iDocCount; i++) {
                HammerNLSAccess theAccess = (HammerNLSAccess) theProject.theLocalNLSDocuments.get(i);
                String sKey = theAccess.sKey;
                String sDoc = theAccess.sDocument;
                if (findNLSDocumentByName(sKey) == null)
                    this.addDocument(sDoc, sKey);
            }
        }
        if ((theProject.getMetaDataUser().getLogFile() != null) && (theProject.getMetaDataUser().getLogFile().isNLSLogging())) {
            theProject.getMetaDataUser().getLogFile().doLogEntry("NLS Load - after loading there are " + this.getDocumentCount() + "NLS Docs", "");
            for (int i = 0; i < getDocumentCount(); i++) {
                AbaNLSDocument theNLSDocument = getNLSDocumentByIndex(i);
                theProject.getMetaDataUser().getLogFile().doLogEntry("NLS Load - Document: " + i, theNLSDocument.getDocumentName());
            }
        }
    }

    public void Load(MetaProject theTemplateProject) throws HammerException {
        clear();
        HammerConfigurationManager theConfigManager;
        theConfigManager = theTemplateProject.getMetaDataUser().getConfigurationManager();
        int iDocCount = theConfigManager.getNLSDocCount();
        for (int i = 0; i < iDocCount; i++) {
            String sKey = theConfigManager.getNLSDocKey(i);
            String sDoc = theConfigManager.getNLSDocName(i);
            if (findNLSDocumentByName(sKey) == null) {
                if (this.addDocument(sDoc, sKey) == false) {
//                    throw new HammerException(HammerException.CANNOT_OPEN_NLS_DOCUMENT, "Cannot find \"" +sDoc +"\"");
                }
            }
        }
        if (theTemplateProject.theLocalNLSDocuments != null) {
            iDocCount = theTemplateProject.theLocalNLSDocuments.size();
            for (int i = 0; i < iDocCount; i++) {
                HammerNLSAccess theAccess = (HammerNLSAccess) theTemplateProject.theLocalNLSDocuments.get(i);
                String sKey = theAccess.sKey;
                String sDoc = theAccess.sDocument;
                if (findNLSDocumentByName(sKey) == null) {

                    if (this.addDocument(sDoc, sKey) == false) {
//                    throw new HammerException(HammerException.CANNOT_OPEN_NLS_DOCUMENT, "Cannot find \"" +sDoc +"\"");
                    }
                }
            }
        }
    }


}
