/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import sun.misc.CompoundEnumeration;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: Jun 27, 2003
 * Time: 6:35:13 PM
 * To change this template use Options | File Templates.
 */
public class HammerClassCustomLoader extends ClassLoader {

    /**
     * Hash table memoizing loaded classes.
     */
    private HashMap hashmap;

    /**
     * Object used to map class names to byte codes.
     */
    String theClassPath;
    ArrayList classPathArrayList = new ArrayList(0);
    ArrayList shortClassPathArrayList = new ArrayList(0);
    HashMap properties = new HashMap();
    HammerClassByteFileLoader classByteFileLoader;
    AbaMetaDataUser theUser             =   null;
    private String m_sClassPath         =   null;
    private String m_sShortClassPath    =   null;
    private boolean bIDEADev            =   false;
    /**
     * quick lookup table - static object shares where a resource was last found.
     */
    static final int QUICK_HASH_SIZE = 257;
    static final int QUICK_MAX_ENTRIES = 16001;
    private static int quickLookupCount = 0;
    static HashMap quickJarLookup = new HashMap(QUICK_HASH_SIZE);

    public HammerClassCustomLoader(AbaMetaDataUser theUser, String sClassPath, String sShortClassPath) {
        this.theClassPath = sClassPath;
        this.theUser = theUser;
        m_sClassPath = sClassPath;
        m_sShortClassPath = sShortClassPath;
        classPathArrayList = makeClassPathArrayList(sClassPath);
        if(sClassPath.equals(sShortClassPath))
            shortClassPathArrayList = classPathArrayList;
        else
            shortClassPathArrayList = makeClassPathArrayList(sShortClassPath);
        hashmap = new HashMap();
        classByteFileLoader = new HammerClassByteFileLoader(classPathArrayList, shortClassPathArrayList, properties, theUser);
        // Read system dependent properties from the environment.
        properties.put("fileSeparator", System.getProperty("file.separator"));
        properties.put("pathSeparator", System.getProperty("path.separator"));
        // Other default properties.
        properties.put("archiveSufffix", ".jar");
        properties.put("compiledSuffix", ".class");
        properties.put("packageSeparator", ".");
        bIDEADev=isDevOn((String)System.getProperty("ch.abacus.renderer.devmode"));
    }

    ArrayList makeClassPathArrayList(String sClassPath) {
        StringTokenizer tokenizer = new StringTokenizer(sClassPath, File.pathSeparator);
        ArrayList v = new ArrayList(0);
        while (tokenizer.hasMoreElements()) {
            String token = (String) tokenizer.nextElement();
            if (v.contains(token) == false)
                v.add(token);
        }
        return v;
    }

    public HammerJarAccess getResourceAccess(String name) {
        HammerJarAccess fastJarAccess = (HammerJarAccess) quickGet(name);

        if (fastJarAccess != null) {
            logClassLoaderMessage("HammerClassCustomLoader@getResourceAsStream@SPEEDFETCH:", "Got " + name);
            return fastJarAccess;
        } else {
            logClassLoaderMessage("In getResourceAccess of hammer class loader - loading:", name);
            ArrayList theJarAccessArray = classByteFileLoader.getJarAccess(name, false, false);
            if (theJarAccessArray == null) {
                logClassLoaderMessage("In getResourceAccess of hammer class loader - Cannot find:", name);
                return null;
            }
            HammerJarAccess theJarAccess = (HammerJarAccess) theJarAccessArray.get(0);
            if (theJarAccess == null) {
                logClassLoaderMessage("In getResourceAccess of hammer class loader - Cannot find:", name);
                return null;
            }
            logClassLoaderMessage("In getResourceAccess of IDE class loader - Found:", name);
            quickPut(name, theJarAccess);
            return theJarAccess;
        }
    }

    public InputStream getResourceAsStream(HammerJarAccess theJarAccess) {
        InputStream is = null;
        if (theJarAccess != null) {
            JarEntry entry = theJarAccess.theJarEntry;
            JarFile jarf = theJarAccess.theJarFile;
            // Get resource bytes from jar file.
            try {
                is = jarf.getInputStream(entry);
            } catch (java.io.IOException e1) {
            }
        }
        logClassLoaderMessage("HammerClassCustomLoader@getResourceAsStream:", "Input stream " + is);
        return is;  // will be null if cannot be obtained from jar file.
    }

    public InputStream getResourceAsStream(String name) {
        HammerJarAccess fastJarAccess = (HammerJarAccess) quickGet(name);

        if (fastJarAccess != null) {
            logClassLoaderMessage("HammerClassCustomLoader@getResourceAsStream@SPEEDFETCH:", "Got " + name);
            InputStream streamReturned = getResourceAsStream(fastJarAccess);
            if (streamReturned != null)
                return streamReturned;
            quickRemove(name);
        }
        logClassLoaderMessage("HammerClassCustomLoader@getResourceAsStream:", "Searching for " + name);
        HammerJarAccess theJarAccess = null;

        // If Dev flag is false use the custom loader order
        // Else if the file is proz and dev flag is true then do not load the
        // proz using custom loader but use the regular classloader. This is accomplis
        // by letting the value be null and then is trapped below where the regular classloader
        // will use the classpath.

        if(bIDEADev==true)
        {
            if(isDevFilterEligible(name)==false)
                theJarAccess = this.getResourceAccess(name);
        }
        else
            theJarAccess = this.getResourceAccess(name);

        if (theJarAccess != null) {
            logClassLoaderMessage("HammerClassCustomLoader@getResourceAsStream:", "Found " + name + " now reading from jar file!");
            InputStream streamReturned = getResourceAsStream(theJarAccess);  // will be null if cannot be obtained from jar file.
            if (streamReturned != null)
                quickPut(name, theJarAccess);
            return streamReturned;
        } //#ALEX Fix, if nothing is found in any jars use the regular classloader
        return ClassLoader.getSystemResourceAsStream(name);
    }

    public HammerInputStream getResourceInPathAsStream(String name) {
        logClassLoaderMessage("HammerClassCustomLoader@getResourceAsStream:", "Searching for " + name);
        HammerJarAccess theJarAccess = null;

        if(bIDEADev==true)
        {
            if(isDevFilterEligible(name)==false)
                theJarAccess = this.getResourceAccess(name);
        }
        else
            theJarAccess = this.getResourceAccess(name);

        if (theJarAccess != null) {
            logClassLoaderMessage("HammerClassCustomLoader@getResourceAsStream:", "Found " + name + " now reading from jar file!");
            HammerInputStream in = new HammerInputStream("", theJarAccess.theJarFile.getName(), theJarAccess.theJarEntry.getName(), getResourceAsStream(theJarAccess));
            return in;  // will be null if cannot be obtained from jar file.
        } //#ALEX Fix, if nothing is found in any jars use the regular classloader
        else {
            HammerInputStream in = new HammerInputStream("", "", "", ClassLoader.getSystemResourceAsStream(name));
            return in;
        }
    }

    public HammerInputStream getFileInPathAsStream(String sFileName) {
        HammerInputStream theRetVal = null;
        logClassLoaderMessage("HammerClassCustomLoader@getFileInPathAsStream:", "Searching for " + sFileName);
        // Search for files.
        if (isDevFilterEligible(sFileName) && bIDEADev==true)
            theRetVal = classByteFileLoader.getFileInPathAsStream(sFileName,true);
        else
            theRetVal = classByteFileLoader.getFileInPathAsStream(sFileName,false);
        // Search for file resources in jars.
        if (theRetVal == null) {
            theRetVal = getResourceInPathAsStream(sFileName);
            if (theRetVal == null) {
                try {
                    FileInputStream in = new FileInputStream(sFileName);
                    if (in != null) {
                        theRetVal = new HammerInputStream("", sFileName, in);
                        return theRetVal;
                    }
                } catch (FileNotFoundException e1) {
                }
            }
        }
        return theRetVal;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        // Check whether the class has been loaded previously by this class loader.
        Object lookup = hashmap.get(name);
        // Return the class from the hash table.
        if (lookup == null)
            throw new ClassNotFoundException("Cannot find class " + name);

        return (Class) lookup;
    }

    /**
     * Only attempts to load hashed classes.  Short cut for proz loading.
     */
    protected Class loadLoadedClass(String name) throws ClassNotFoundException {
        Class resultClass = null;

        // Check whether the class has been loaded previously by this class loader.
        Object lookup = hashmap.get(name);
        logClassLoaderMessage("In loadClass of hammer class loader - Attempting to load:", name);
        // If so, return the class from the hash table.
        if (lookup != null) {
            resultClass = (Class) lookup;
            logClassLoaderMessage("In loadClass of hammer class loader - Already loaded!:", name);
            return resultClass;
        }
        throw new ClassNotFoundException(name);
    }
    /**
     * Attempts to load the named class.
     *
     * @param name		the name of the class to be loaded
     * @param resolve	flag specifying whether referenced classes should be resolved
     * @return			the loaded class
     * @exception		ClassNotFoundException	if the class cannot be loaded
     */
    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class resultClass = null;

        // Check whether the class has been loaded previously by this class loader.
        Object lookup = hashmap.get(name);
        logClassLoaderMessage("In loadClass of hammer class loader - Attempting to load:", name);
        // If so, return the class from the hash table.
        if (lookup != null) {
            resultClass = (Class) lookup;
            logClassLoaderMessage("In loadClass of hammer class loader - Already loaded!:", name);
            return resultClass;
        } else {
            try {
                // Look in system classes first.
                try {
                    Class clsThroughSystemLoader = Class.forName(name);
                    if (clsThroughSystemLoader != null)
                        return clsThroughSystemLoader;
                } catch (ClassNotFoundException e99) {
                }
                // Read the bytes from the appropriate .class file.
                byte[] classBytes = classByteFileLoader.getClassBytes(name);
                // Throw exception if the class byte loader failed to load the bytes.
                if (classBytes == null) {
                    throw new ClassNotFoundException("ClassByteLoader.get returned null for class " + name);
                }
                // Convert the array to a class.
                // Just debugging.
//                    if (name.equals("app1.mainx")) {
//                        File theFile = new File("JunkXXX");
//                        if (theFile.exists())
//                            theFile.delete();
//                        try {
//                            FileOutputStream theOutputStream = new FileOutputStream(theFile);
//                            theOutputStream.write(classBytes);
//                            theOutputStream.close();
//                        }
//                        catch (FileNotFoundException e97) {
//                        }
//                        catch (java.io.IOException e971) {
//                        }
//                    }
                resultClass = defineClass(name, classBytes, 0, classBytes.length);
            } catch (ClassFormatError e2) {
//                    theDesignCockpit.theErrorManager.doNormalServerError(IDEErrorManager.CLASS_LOADER_BAD_FORMAT_ERROR, "Bad format for class "+ name + " "+ e2);
                System.err.println("Bad format for class " + name + " " + e2);
                throw new ClassNotFoundException("format of class file incorrect for class " + name + ": " + e2.getMessage());
            }
        }
        // Resolve the class if necessary.
        if (resolve) resolveClass(resultClass);
        // Memorize the class for any further loading attempts.
        hashmap.put(name, resultClass);
        logClassLoaderMessage("In loadClass of hammer class loader - New class loaded!:", name);
        return resultClass;
    }

    /**
     * Finds the resource with the given name. A resource is some data
     * (images, audio, text, etc) that can be accessed by class code in a way
     * that is independent of the location of the code.<p>
     *
     * The name of a resource is a "/"-separated path name that identifies
     * the resource.<p>
     *
     * This method will first search the parent class loader for the resource;
     * if the parent is <code>null</code> the path of the class loader
     * built-in to the virtual machine is searched.  That failing, this method
     * will call <code>findResource</code> to find the resource.<p>
     *
     * @param  name resource name
     * @return a URL for reading the resource, or <code>null</code> if
     *         the resource could not be found or the caller doesn't have
     *         adequate privileges to get the resource.
     * @since  JDK1.1
     * @see #findResource(String)
     */
    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (url == null) {
            url = findResource(name);
        }
        return url;
    }


    /**
     * Returns an Enumeration of URLs representing all the resources with
     * the given name. Class loader implementations should override this
     * method to specify where to load resources from.
     *
     * @param  name the resource name
     * @return an Enumeration of URLs for the resources
     * @throws java.io.IOException if I/O errors occur
     * @since  1.2
     */
    protected Enumeration findResources(String name) throws IOException {
        return new CompoundEnumeration(new Enumeration[0]);
    }

    /**
     * Finds the resource with the given name. Class loader
     * implementations should override this method to specify where to
     * find resources.
     *
     * @param  resource the resource name
     * @return a URL for reading the resource, or <code>null</code>
     *         if the resource could not be found
     * @since  1.2
     */


    protected URL findResource(String resource) {
        logClassLoaderMessage("In findResource of hammer class loader.  Resource is: ", resource);

//    URL urlOfParentLoader = super().findResource(resource);
//    if (urlOfParentLoader != null)
//        return urlOfParentLoader;
        String sJarFileName = classByteFileLoader.findJarFileWithResource(resource);
        // Find the name of the jar with the resource.
        if (sJarFileName != null) {
            try {
                logClassLoaderMessage("In findResource of IDE class loader.  Jar file name is: ", sJarFileName);
                return new URL(getJarURL(sJarFileName) + resource);
            } catch (MalformedURLException mue) {
            }
        }
        logClassLoaderMessage("Cannot find resource in IDE class loader: ", resource);
        return null;
    }

    /**
     *@return the URL for the supplied jar
     */
    private String getJarURL(String sJarName) {
        StringBuffer buf = new StringBuffer("jar:file:");
        buf.append(sJarName.replace('\\', '/'));
        buf.append("!/");
        String fJarURLPath = buf.toString();
        logClassLoaderMessage("In getJarURL.  Jar path is: ", fJarURLPath);
        return fJarURLPath;
    }

    public Class[] getClassesFromPath(String sSearchPath) {
        String fileSeparator = (String) properties.get("fileSeparator");
        String packageSeparator = (String) properties.get("packageSeparator");
        ArrayList theClassByteArray = classByteFileLoader.getClassesFromPath(sSearchPath);
        if (theClassByteArray == null)
            return null;
        if (theClassByteArray.size() == 0)
            return null;
        Class[] retVal = new Class[theClassByteArray.size()];
        for (int i = 0; i < theClassByteArray.size(); i++) {
            HammerClassDescriptor descriptor = (HammerClassDescriptor) theClassByteArray.get(i);
            String sClassName = descriptor.sClassName;

//          String sEntry = new Integer(i).toString();
//          theDesignCockpit.theLogFile.doLogEntry(sEntry, " " + sClassName);

            if (sClassName.endsWith(".class")) {
                sClassName = sClassName.substring(0, sClassName.length() - 6);
            }
            int iMatch = sClassName.indexOf(fileSeparator);
            while (iMatch != -1) {
                if (iMatch == 0) {
                    if (sClassName.length() > 1)
                        sClassName = sClassName.substring(iMatch + 1);
                    else {
                        sClassName = "";
                        break;
                    }
                } else
                    sClassName = sClassName.substring(0, iMatch) + packageSeparator + sClassName.substring(iMatch + 1);
                iMatch = sClassName.indexOf(fileSeparator);
            }
            // fix the search path.
            iMatch = sSearchPath.indexOf("/");
            while (iMatch != -1) {
                if (iMatch == 0) {
                    if (sSearchPath.length() > 1)
                        sSearchPath = sSearchPath.substring(iMatch + 1);
                    else {
                        sSearchPath = "";
                        break;
                    }
                } else
                    sSearchPath = sSearchPath.substring(0, iMatch) + packageSeparator + sSearchPath.substring(iMatch + 1);
                iMatch = sSearchPath.indexOf("/");
            }

            int iBegin = sClassName.indexOf(sSearchPath);
            if (iBegin != -1) {
                sClassName = sClassName.substring(iBegin);
            }
            Class clsCreated = null;
            try {
                clsCreated = defineClass(sClassName, descriptor.classBytes, 0, descriptor.classBytes.length);
            } catch (java.lang.LinkageError e1) {
                // Class already defined in path.  We can only have one.
            }
            if (clsCreated != null) {
                retVal[i] = clsCreated;
                resolveClass(retVal[i]);
            }
        }
        return retVal;
    }

    public void setPaths(String sClassPath, String sShortPath) {
        theClassPath = sClassPath;
        if(m_sClassPath.equals(sClassPath)==false)
        {
            classPathArrayList = makeClassPathArrayList(sClassPath);
        }
        if(m_sShortClassPath.equals(sShortPath)==false)
            shortClassPathArrayList = makeClassPathArrayList(sShortPath);
        classByteFileLoader.setPaths(classPathArrayList, shortClassPathArrayList);
    }

    public Class defineClass(String sClassName, byte[] bytes) {
        Class clsCreated;
        Object lookup = hashmap.get(sClassName);
        if (lookup != null)
            return (Class) lookup;
        try {
            clsCreated = defineClass(sClassName, bytes, 0, bytes.length);
            hashmap.put(sClassName, clsCreated);
        } catch (java.lang.LinkageError e1) {
            // Class already defined in path.  We can only have one.
            return null;
        }
        return clsCreated;
    }

    Object quickGet(String name) {
        Object quick = quickJarLookup.get(name);
//        if (quick!=null)
//            System.out.println("Quick for "+name);
        return quick;
    }

    void quickPut(Object key, Object name) {
        if (quickLookupCount<QUICK_MAX_ENTRIES) {
            quickJarLookup.put(key, name);
            quickLookupCount++;
        }
    }

    void quickRemove(Object key) {
        quickJarLookup.remove(key);
    }

    private void logClassLoaderMessage (String sDesription, String sMessage) {
        if ((theUser != null) && (theUser.getLogFile() != null) && (theUser.getLogFile().bClassLoaderLogging))
            theUser.getLogFile().doClassLoaderLogEntry(sDesription, sMessage);
    }

    protected boolean isDevOn(String fileName)
    {
        boolean rtVal = false;

        if(fileName==null)
            return rtVal;
        else if(fileName.equalsIgnoreCase("on"))
            rtVal = true;

        return rtVal;
    }

    protected boolean isDevFilterEligible(String fileName)
    {
        boolean rtVal = false;

        if(fileName.endsWith(".proz"))
            rtVal = true;
        else if(fileName.endsWith(".nls"))
            rtVal = true;

        return rtVal;
    }
}
