/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;

import javax.swing.*;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;


/**
 * <p>Title: Design Cockpit</p>
 * <p>Description: Abacus Design Cockpit </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: Abacus </p>
 * @author Michael Gouker - Cagey Logic
 * @version 1.0
 *
 *  The log console is created for each thread that writes to standard err or standard out.
 *  Log consoles are only destroyed by user interaction or when the AbaJamm server is shut down.
 *
 * Each Console window consists of a scrollable editor and three buttons:
 *
 *  1. Save (saves to a file)
 *  2. Print (prints to a printer)
 *  3. Reset (resets contents)
 *
 *    You can minimize the log window.
 *    Closing the log window destroys the contents.
 *    You can edit the contents of the editor before you save to make annotations.
 *
 */


public class HammerLogConsole extends JAFrame {
    public Thread theThread;
    public HammerLogConsole theLogFrame = this;
    protected JAScrollPane theLogPane = new JAScrollPane();
    protected JATextAreaX theLogTextOutputWindow = new JATextAreaX(this);
    protected JButton theResetLogButton = new JButton();
    protected JButton theSaveLogButton = new JButton();
    protected JButton thePrintLogButton = new JButton();
    protected HammerLogOutputStream theCreator = null;

    CutAction cutAction = null;
    CopyAction copyAction = null;
    PasteAction pasteAction = null;
    OpenAction openAction = null;
    SaveAction saveAction = null;
    SaveAsAction saveAsAction = null;
    NewAction newAction = null;
    CloseAction closeAction = null;
    AboutAction aboutAction = null;
    UndoAction undoAction = null;
    RedoAction redoAction = null;

    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu = new JMenu("File");
    JMenu editMenu = new JMenu("Edit");
    JMenu windowMenu = new JMenu("Window");
    JMenu helpMenu = new JMenu("Help");

    public AbstractAction lastClipboardBufferingAction = null;


    int iByteCount = 0;
    String sBuffer = new String("");

    public HammerLogConsole(HammerLogOutputStream theCreator) {
        this.theCreator = theCreator;
        theThread = Thread.currentThread();
        //  Set the layout.
        // This is how the console layout works.
        //
        // theLogPane is the entire frame.
        // theContainer is the container inside the frame.  It uses border layout.
        // Inside are:
        //    theMenuPanel - consisting of the menu & toolbar
        //    theMainPanel - consisting of the main text area.
        //    theStatusBar - Just the status bar.

        PrintStream saveErr = System.err;
//      System.setErr(theCreator.theServer.oldErr);

        Container theContainer = getContentPane();

        // Create a panel and attach it to the top of the frame.
        // This panel is for the menubar and the toolbar.
        JAPanel theMenuPanel = new JAPanel(false);
        theMenuPanel.setLayout(new GridLayout(2, 1));
        JAPanel theMainPanel = new JAPanel(false);
        AnchoringLayoutManager layoutManagertheLogFrame = new AnchoringLayoutManager();
        theMainPanel.setLayout(layoutManagertheLogFrame);

        setLocation(32, 192);
        setSize(520, 504);
//    if (theCreator.theServer.theLogFile.bDedicatedConsoles==false)
        setTitle("Design Cockpit Log");
//    else
//        setTitle("Design Cockpit Log For Thread: "+theThread);

        // MenuBar
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
//      menuBar.add(toolsMenu);
        menuBar.add(helpMenu);


        // Toolbar
        JToolBar toolBar = new JToolBar();
//      String sImageDirectory = theCreator.theServer.sBaseDir + "Resources" + theCreator.theServer.jammCacheManager.theSeparator;
        String sImageDirectory = "";
        Icon newIcon = new ImageIcon(sImageDirectory + "Glp_new.gif");
        Icon openIcon = new ImageIcon(sImageDirectory + "Glp_open.gif");
        Icon saveIcon = new ImageIcon(sImageDirectory + "Glp_save.gif");
        Icon cutIcon = new ImageIcon(sImageDirectory + "Glp_cut.gif");
        Icon copyIcon = new ImageIcon(sImageDirectory + "Glp_copy.gif");
        Icon pasteIcon = new ImageIcon(sImageDirectory + "Glp_paste.gif");
        Icon aboutIcon = new ImageIcon(sImageDirectory + "Glp_about.gif");
//      Icon fontIcon = new ImageIcon("glp_Font.gif");
//      Icon colorIcon = new ImageIcon("glp_Color.gif");
        Icon undoIcon = new ImageIcon(sImageDirectory + "glp_Undo.gif");
        Icon redoIcon = new ImageIcon(sImageDirectory + "glp_Redo.gif");

        toolBar.setMargin(new Insets(5, 5, 5, 5));
        toolBar.setFocusable(false);

        newAction = new NewAction("New", newIcon, this);
        closeAction = new CloseAction("Close", null, this);
        openAction = new OpenAction("Open", openIcon, this);
        saveAction = new SaveAction("Save", saveIcon, this);
        saveAsAction = new SaveAsAction("Save As", saveIcon, this);

        cutAction = new CutAction("Cut", cutIcon, this);
        copyAction = new CopyAction("Copy", copyIcon, this);
        pasteAction = new PasteAction("Paste", pasteIcon, this);

        aboutAction = new AboutAction("About", aboutIcon, this);
//      fontChooserAction = new FontChooserAction("Set &Font", fontIcon, this);
//      fgcolorChooserAction = new ForegroundColorChooserAction("Set Fore&ground Color", colorIcon, this);
//      bgcolorChooserAction = new BackgroundColorChooserAction("Set &Background Color", colorIcon, this);
        undoAction = new UndoAction("Undo", undoIcon, this);
        redoAction = new RedoAction("Redo", redoIcon, this);

        toolBar.add(newAction);
        toolBar.add(openAction);
        toolBar.add(saveAction);
        toolBar.addSeparator();
        toolBar.add(cutAction);
        toolBar.add(copyAction);
        toolBar.add(pasteAction);
        toolBar.add(undoAction);
        toolBar.add(redoAction);

        fileMenu.add(newAction);
        fileMenu.add(openAction);
        fileMenu.add(saveAction);
        fileMenu.add(saveAsAction);
        fileMenu.add(closeAction);

        editMenu.add(cutAction);
        editMenu.add(copyAction);
        editMenu.add(pasteAction);
        editMenu.add(undoAction);
        editMenu.add(redoAction);

//      JMenuItem jmItemFontChooser = toolsMenu.add(fontChooserAction);
//      JMenuItem jmItemForegroundColorChooser = toolsMenu.add(fgcolorChooserAction);
//      JMenuItem jmItemBackgroundColorChooser = toolsMenu.add(bgcolorChooserAction);

        helpMenu.add(aboutAction);

        // Now format the layouts.
        theMenuPanel.add(menuBar);
        theMenuPanel.add(toolBar);
        theContainer.add(theMenuPanel, BorderLayout.NORTH);
        theContainer.add(theMainPanel, BorderLayout.CENTER);
//      theContainer.add(theStatusPanel, BorderLayout.SOUTH);

        // Done with layout.

        theLogPane.setLocation(20, 40);
        theLogPane.setSize(480, 300);
        theMainPanel.add(theLogPane, "theLogPane");
        layoutManagertheLogFrame.setAnchoring(theLogPane, true, true, true, true);
        theLogTextOutputWindow.setLocation(0, 0);
        theLogTextOutputWindow.setSize(480, 300);
        theLogTextOutputWindow.setText("");
        theLogTextOutputWindow.thePane = theLogPane;
        theLogTextOutputWindow.fixupSize();
        //  Add the control theLogTextOutputWindow to the content pane.
        theLogPane.setViewportView(theLogTextOutputWindow);



        //  Add the control theLogPane to the content pane.

//    getContentPane().add(theLogPane, "theLogPane");
//    layoutManagertheLogFrame.setAnchoring(theLogPane, true, true, true, true);
//    theLogTextOutputWindow.setLocation(0, 0);
//    theLogTextOutputWindow.setSize(480, 248);
//    theLogTextOutputWindow.setText("");
//    theLogTextOutputWindow.thePane = (JAScrollPane) theLogPane;
//    theLogTextOutputWindow.fixupSize();
//    //  Add the control theLogTextOutputWindow to the content pane.
//    theLogPane.setViewportView(theLogTextOutputWindow);
//    theResetLogButton.setLocation(24, 352);
//    theResetLogButton.setSize(104, 48);
//    theResetLogButton.setText("Reset Log");
//    //  Add the control theResetLogButton to the content pane.
//    getContentPane().add(theResetLogButton, "theResetLogButton");
//    layoutManagertheLogFrame.setAnchoring(theResetLogButton, true, false, false, true);
//    theResetLogButton.addActionListener( new theResetLogButton$$$ActionListener(this) );
//    theSaveLogButton.setLocation(152, 352);
//    theSaveLogButton.setSize(104, 48);
//    theSaveLogButton.setText("Save Log");
//    //  Add the control theSaveLogButton to the content pane.
//    getContentPane().add(theSaveLogButton, "theSaveLogButton");
//    layoutManagertheLogFrame.setAnchoring(theSaveLogButton, true, false, false, true);
//    theSaveLogButton.addActionListener( new theSaveLogButton$$$ActionListener(this) );
//    thePrintLogButton.setLocation(280, 352);
//    thePrintLogButton.setSize(104, 48);
//    thePrintLogButton.setText("Print Log");
//    //  Add the control thePrintLogButton to the content pane.
//    getContentPane().add(thePrintLogButton, "thePrintLogButton");
//    layoutManagertheLogFrame.setAnchoring(thePrintLogButton, true, false, false, true);
//    thePrintLogButton.addActionListener( new thePrintLogButton$$$ActionListener(this) );
//    // Show the main window

        addWindowListener(new WindowEventHandler());
        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        show();
        System.setErr(saveErr);

    }


    void addByte(int byte_to_write) {
        iByteCount++;
        char c = (char) (byte_to_write & 0x00ff);
        if (c != 0) {
            sBuffer = sBuffer + c;
            if (c < ' ')  // non printable character?
                flush();
        } else {
            theLogTextOutputWindow.append(sBuffer);
            sBuffer = new String("");
            iByteCount = 0;
        }
    }

    void flush() {
        theLogTextOutputWindow.append(sBuffer);
        sBuffer = new String("");
        iByteCount = 0;
    }

    /***__@Listener: [theResetLogButton$$$ActionListener] ***/
    class theResetLogButton$$$ActionListener implements ActionListener {
        HammerLogConsole theIDELogConsole;

        public theResetLogButton$$$ActionListener(HammerLogConsole theIDELogConsole) {
            this.theIDELogConsole = theIDELogConsole;
        }

        /***__@Method: [actionPerformed] ***/
        public void actionPerformed(java.awt.event.ActionEvent p0) {
            theIDELogConsole.theLogTextOutputWindow.setText("");
        }

        /***__@@Method: [actionPerformed] ***/
    }

    class WindowEventHandler extends WindowAdapter {
        public void windowClosing(WindowEvent evt) {
            HammerLogConsole thisConsole = (HammerLogConsole) evt.getSource();
            thisConsole.theCreator.theLogConsoles.remove(thisConsole);
        }
    }


    public void editorAction(String theActionName, ActionEvent evt, HammerLogConsole theIDELogConsole) {

        Object theActiveEditor = theIDELogConsole.theLogTextOutputWindow;
        Class clsActiveEditor = theActiveEditor.getClass();
        Class[] clsParams = new Class[1];
        clsParams[0] = (new String()).getClass();
        try {
            Method m = clsActiveEditor.getMethod("getActionByName", clsParams);
            Object[] objParams = new Object[1];
            objParams[0] = theActionName;
            Object obj = m.invoke(theActiveEditor, objParams);
            if ((obj != null) && (obj instanceof Action)) {
                Action action = (Action) obj;
                action.actionPerformed(evt);
            }
        } catch (InvocationTargetException e1) {
            System.out.println("Invocation error");
        } catch (NoSuchMethodException e2) {
            System.out.println("No such method error");
        } catch (IllegalAccessException e3) {
            System.out.println("Illegal Access error");
        }
    }

    class CutAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public CutAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            editorAction("cut-to-clipboard", evt, theIDELogConsole);
        }
    }

    class CopyAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public CopyAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            editorAction("copy-to-clipboard", evt, theIDELogConsole);
        }
    }

    class PasteAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public PasteAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            editorAction("paste-from-clipboard", evt, theIDELogConsole);
        }
    }


    class OpenAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public OpenAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            JFileChooser theFileChooser = new JFileChooser(); //(theIDELogConsole.getCurrentDirectory());
            theFileChooser.addChoosableFileFilter(new HammerLogFileFilter());
            theFileChooser.setFileView(new HammerLogFileView());
            int iOptionSelected = theFileChooser.showOpenDialog(theIDELogConsole.getContentPane());
            if (iOptionSelected == JFileChooser.APPROVE_OPTION) {
                File file = theFileChooser.getSelectedFile();
                try {
                    String sFullPath = file.getCanonicalPath();
                    theIDELogConsole.theLogTextOutputWindow.setText("");
                    BufferedReader in = new BufferedReader(new FileReader(sFullPath));
                    String sLine;
                    String sText = "";
                    while ((sLine = in.readLine()) != null) {
                        sText = sText + "\r\n" + sLine;
                    }
                    in.close();
                    theIDELogConsole.theLogTextOutputWindow.setText(sText);
                } catch (java.io.IOException e1) {
                }
            }
        }
    }

    class CloseAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public CloseAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
        }
    }

    class NewAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public NewAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            theIDELogConsole.theLogTextOutputWindow.setText("");
        }
    }

    class AboutAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public AboutAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            new HammerConsoleAboutBox(theIDELogConsole);
        }
    }

    class FontChooserAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public FontChooserAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
//          IDEObjectFontChooser theChooser = new IDEObjectFontChooser(theIDELogConsole);
        }
    }

    class UndoAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public UndoAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            JATextAreaX theEditor = theIDELogConsole.theLogTextOutputWindow;
            Class clsActiveEditor = theEditor.getClass();
            Class[] clsParams = new Class[0];
            try {
                Method m = clsActiveEditor.getMethod("undo", clsParams);
                Object[] objParams = new Object[0];
                m.invoke(theEditor, objParams);
            } catch (InvocationTargetException e1) {
                System.out.println("Invocation error");
            } catch (NoSuchMethodException e2) {
                System.out.println("No such method error");
            } catch (IllegalAccessException e3) {
                System.out.println("Illegal Access error");
            }

        }
    }

    class RedoAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public RedoAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            JATextAreaX theEditor = theIDELogConsole.theLogTextOutputWindow;
            Class clsActiveEditor = theEditor.getClass();
            Class[] clsParams = new Class[0];
            try {
                Method m = clsActiveEditor.getMethod("redo", clsParams);
                Object[] objParams = new Object[0];
                m.invoke(theEditor, objParams);
            } catch (InvocationTargetException e1) {
                System.out.println("Invocation error");
            } catch (NoSuchMethodException e2) {
                System.out.println("No such method error");
            } catch (IllegalAccessException e3) {
                System.out.println("Illegal Access error");
            }
        }
    }

    class ForegroundColorChooserAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public ForegroundColorChooserAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
//          IDEObjectColorChooser theChooser = new IDEObjectColorChooser(theIDELogConsole, true);
        }
    }

    class BackgroundColorChooserAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public BackgroundColorChooserAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
//          IDEObjectColorChooser theChooser = new IDEObjectColorChooser(theIDELogConsole, false);
        }
    }

    class SaveAsAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public SaveAsAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
        }
    }

    class SaveAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public SaveAction(String label, Icon icon, HammerLogConsole theIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = theIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            String sFileName = "";
//        String sDirectoryName = theIDELogConsole.theCreator.theServer.theConfigurationManager.getConfiguredDirectory("log");
            String sDirectoryName = "";
            JFileChooser theFileChooser = new JFileChooser(sDirectoryName);
            theFileChooser.addChoosableFileFilter(new HammerLogFileFilter());
            theFileChooser.setFileView(new HammerLogFileView());
            int iOptionSelected = theFileChooser.showSaveDialog(getContentPane());
            if (iOptionSelected == JFileChooser.APPROVE_OPTION) {
                try {
                    File file = theFileChooser.getSelectedFile();
                    sFileName = file.getCanonicalPath();
                } catch (java.io.IOException e93) {
                    return;
                }
            } else
                return;

            // Create the document generator.
            File theOutputLogFile = new File(sFileName);
            // Generate the output document.
            try {
                PrintWriter pw = new PrintWriter(new FileOutputStream(theOutputLogFile));
                JATextAreaX theTextWindow = theIDELogConsole.theLogTextOutputWindow;
                int iLines = theTextWindow.getLineCount();
                for (int iLine = 0; iLine < iLines; iLine++) {
                    int iOffset = theTextWindow.getLineStartOffset(iLine);
                    int iLength = theTextWindow.getLineEndOffset(iLine) - iOffset;
                    String sText = theTextWindow.getText(iOffset, iLength);
                    if (sText.length() > 0)
                        pw.print(sText);
                }
                pw.flush();
                pw.close();
            } catch (Exception e1) {
            }
        }

    }



    /***__@@Listener: [ActionListener] ***/
    /***__@Listener: [theSaveLogButton$$$ActionListener] ***/
    class theSaveLogButton$$$ActionListener implements ActionListener {
        HammerLogConsole theIDELogConsole;

        public theSaveLogButton$$$ActionListener(HammerLogConsole theIDELogConsole) {
            this.theIDELogConsole = theIDELogConsole;
        }

        /***__@Method: [actionPerformed] ***/
        public void actionPerformed(java.awt.event.ActionEvent p0) {
            String sFileName = "";
//        String sDirectoryName = theIDELogConsole.theCreator.theServer.theConfigurationManager.getConfiguredDirectory("log");
            String sDirectoryName = "";
            JFileChooser theFileChooser = new JFileChooser(sDirectoryName);
            theFileChooser.addChoosableFileFilter(new HammerLogFileFilter());
            theFileChooser.setFileView(new HammerLogFileView());
            int iOptionSelected = theFileChooser.showSaveDialog(getContentPane());
            if (iOptionSelected == JFileChooser.APPROVE_OPTION) {
                try {
                    File file = theFileChooser.getSelectedFile();
                    sFileName = file.getCanonicalPath();
                } catch (java.io.IOException e93) {
                    return;
                }
            } else
                return;

            // Create the document generator.
            File theOutputLogFile = new File(sFileName);
            // Generate the output document.
            try {
                PrintWriter pw = new PrintWriter(new FileOutputStream(theOutputLogFile));
                JATextAreaX theTextWindow = theIDELogConsole.theLogTextOutputWindow;
                int iLines = theTextWindow.getLineCount();
                for (int iLine = 0; iLine < iLines; iLine++) {
                    int iOffset = theTextWindow.getLineStartOffset(iLine);
                    int iLength = theTextWindow.getLineEndOffset(iLine) - iOffset;
                    String sText = theTextWindow.getText(iOffset, iLength);
                    if (sText.length() > 0)
                        pw.print(sText);
                }
                pw.flush();
                pw.close();
            } catch (Exception e1) {
            }
        }

        /***__@@Method: [actionPerformed] ***/
    }
    /***__@@Listener: [ActionListener] ***/
    /***__@Listener: [thePrintLogButton$$$ActionListener] ***/
    class thePrintLogButton$$$ActionListener implements ActionListener {
        HammerLogConsole theIDELogConsole;

        public thePrintLogButton$$$ActionListener(HammerLogConsole theIDELogConsole) {
            this.theIDELogConsole = theIDELogConsole;
        }

        /***__@Method: [actionPerformed] ***/
        public void actionPerformed(java.awt.event.ActionEvent p0) {
            System.out.println("Hello I am printing");

        }

        /***__@@Method: [actionPerformed] ***/
    }

    /***__@@Listener: [ActionListener] ***/

    class JATextAreaX extends javax.swing.JTextArea implements UndoableEditListener {
        /***__@Member Data: [thePane] ***/
        /**
         *
         *  thePane -
         *
         */

        protected javax.swing.JScrollPane thePane = null;
        HammerLogConsole theIDELogConsole;
        Hashtable actions;
        public HammerLogEditorPopupMenu thePopupMenu = null;

        public static final int UNDO_LIMIT = 1500;

        //UndoManager
        private UndoManager m_undoManager;


        /***__@@Member Data: [thePane] ***/
        /**
         *  Constructor for class JATextAreaX derived from constructor of javax.swing.JATextArea
         */

        public JATextAreaX(HammerLogConsole theIDELogConsole) {
            super();
            this.theIDELogConsole = theIDELogConsole;
            init();
        }


        void init() {
            addCaretListener(new HammerLogSourceCaretListener(theIDELogConsole));
            thePopupMenu = new HammerLogEditorPopupMenu(this, theIDELogConsole);
            addMouseListener(new HammerLogEditorMouseListener(this, thePopupMenu));
            createActionTable();
            //add the UndoableEditListener to the TextArea
            getDocument().addUndoableEditListener(this);
            createUndoMananger();
        }

        private void createActionTable() {
            actions = new Hashtable();
            Action[] actionsArray = getActions();
            for (int i = 0; i < actionsArray.length; i++) {
                Action a = actionsArray[i];
                String sActionName = (String) a.getValue(Action.NAME);
//            System.out.println(sActionName);
                actions.put(sActionName, a);
            }
        }

        public Action getActionByName(String name) {
            return (Action) (actions.get(name));
        }

        //createUndoMananger creating undo manager
        private void createUndoMananger() {
            m_undoManager = new UndoManager();
            m_undoManager.setLimit(UNDO_LIMIT);
        }

        //undoableEditHappened called when edit happened
        public void undoableEditHappened(UndoableEditEvent e) {
            //add the edits to the unod manager
            m_undoManager.addEdit(e.getEdit());
        }

        public void undo() {
            try {
                //Undo changes
                m_undoManager.undo();
            } catch (CannotUndoException cue) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public void redo() {
            try {
                //Redo changes
                m_undoManager.redo();
            } catch (CannotRedoException cue) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        /***__@Method: [fixupSize] ***/
        void fixupSize() {
            int iRows = getRows();
            int iColumns = getColumns();
            Font theFont = getFont();
            if (theFont != null) {
                FontMetrics theFontMetrics = getFontMetrics(theFont);
                if (theFontMetrics != null) {
                    int iXSize = iColumns * theFontMetrics.stringWidth("m    WXZ") / 8;
                    int iYSize = iRows * theFontMetrics.getHeight();
                    thePane.setPreferredSize(new Dimension(iXSize, iYSize));
                }
            }
        }

        /***__@@Method: [fixupSize] ***/
    }
    /***__@@Class: [JATextAreaX] ***/

}

class HammerLogEditorPopupMenu extends JPopupMenu {
    HammerLogConsole theConsole = null;
    EditorUndoAction theUndoAction = null;
    EditorRedoAction theRedoAction = null;
    EditorCutAction theCutAction = null;
    EditorCopyAction theCopyAction = null;
    EditorPasteAction thePasteAction = null;
    Object theEditor = null;
    EditorSelectAllAction theSelectAllAction = null;
//    EditorDeleteAction theDeleteAction = null;
    public HammerLogEditorPopupMenu(Object objEditor, HammerLogConsole objConsole) {
        super();
        theConsole = objConsole;
        theEditor = objEditor;
        theUndoAction = new EditorUndoAction("Undo", null, theConsole);
        theRedoAction = new EditorRedoAction("Redo", null, theConsole);
        theCutAction = new EditorCutAction("Cut", null, theConsole);
        theCopyAction = new EditorCopyAction("Copy", null, theConsole);
        thePasteAction = new EditorPasteAction("Paste", null, theConsole);
        theSelectAllAction = new EditorSelectAllAction("Select All", null, theConsole);
//        theDeleteAction = new EditorDeleteAction("Delete", null, theIDELogConsole);

        add(theUndoAction);
        add(theRedoAction);
        addSeparator();
        add(theCutAction);
        add(theCopyAction);
        add(thePasteAction);
        addSeparator();
        add(theSelectAllAction);

    }

    public void editorAction(String theActionName, ActionEvent evt) {

        Class clsActiveEditor = theEditor.getClass();
        Class[] clsParams = new Class[1];
        clsParams[0] = (new String()).getClass();
        try {
            Method m = clsActiveEditor.getMethod("getActionByName", clsParams);
            Object[] objParams = new Object[1];
            objParams[0] = theActionName;
            Object obj = m.invoke(theEditor, objParams);
            if ((obj != null) && (obj instanceof Action)) {
                Action action = (Action) obj;
                action.actionPerformed(evt);
            }
        } catch (InvocationTargetException e1) {
            System.out.println("Invocation error");
        } catch (NoSuchMethodException e2) {
            System.out.println("No such method error");
        } catch (IllegalAccessException e3) {
            System.out.println("Illegal Access error");
        }
    }

    class EditorCutAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public EditorCutAction(String label, Icon icon, HammerLogConsole objIDELogConsole) {
            super(label, icon);
            theIDELogConsole = objIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            editorAction("cut-to-clipboard", evt);
        }
    }

    class EditorSelectAllAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public EditorSelectAllAction(String label, Icon icon, HammerLogConsole objIDELogConsole) {
            super(label, icon);
            theIDELogConsole = objIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            editorAction("select-all", evt);
        }
    }

    class EditorCopyAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public EditorCopyAction(String label, Icon icon, HammerLogConsole objIDELogConsole) {
            super(label, icon);
            theIDELogConsole = objIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            editorAction("copy-to-clipboard", evt);
        }
    }

    class EditorPasteAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public EditorPasteAction(String label, Icon icon, HammerLogConsole objIDELogConsole) {
            super(label, icon);
            theIDELogConsole = objIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            editorAction("paste-from-clipboard", evt);
        }
    }

    class EditorUndoAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public EditorUndoAction(String label, Icon icon, HammerLogConsole objIDELogConsole) {
            super(label, icon);
            theIDELogConsole = objIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            Class clsActiveEditor = theEditor.getClass();
            Class[] clsParams = new Class[0];
            try {
                Method m = clsActiveEditor.getMethod("undo", clsParams);
                Object[] objParams = new Object[0];
                m.invoke(theEditor, objParams);
            } catch (InvocationTargetException e1) {
                System.out.println("Invocation error");
            } catch (NoSuchMethodException e2) {
                System.out.println("No such method error");
            } catch (IllegalAccessException e3) {
                System.out.println("Illegal Access error");
            }
        }
    }

    class EditorRedoAction extends AbstractAction {
        HammerLogConsole theIDELogConsole = null;

        public EditorRedoAction(String label, Icon icon, HammerLogConsole objIDELogConsole) {
            super(label, icon);
            theIDELogConsole = objIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            Class clsActiveEditor = theEditor.getClass();
            Class[] clsParams = new Class[0];
            try {
                Method m = clsActiveEditor.getMethod("redo", clsParams);
                Object[] objParams = new Object[0];
                m.invoke(theEditor, objParams);
            } catch (InvocationTargetException e1) {
                System.out.println("Invocation error");
            } catch (NoSuchMethodException e2) {
                System.out.println("No such method error");
            } catch (IllegalAccessException e3) {
                System.out.println("Illegal Access error");
            }
        }
    }

}


class HammerLogSourceCaretListener implements CaretListener {
    int iDotPos;
    int iMarkPos;
    HammerLogConsole theIDELogConsole = null;

    public HammerLogSourceCaretListener(HammerLogConsole theIDELogConsole) {
        this.theIDELogConsole = theIDELogConsole;
    }

    public void caretUpdate(CaretEvent evt) {
        iDotPos = evt.getDot();
        iMarkPos = evt.getMark();
//        theIDELogConsole.updateStatus(iDotPos, iMarkPos);
    }

}

class HammerLogEditorMouseListener implements MouseListener {
    Component theEditor;
    JPopupMenu thePopupMenu;

    public HammerLogEditorMouseListener(Component objEditor, JPopupMenu objPopupMenu) {
        theEditor = objEditor;
        thePopupMenu = objPopupMenu;
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        showPopup(evt);
    }

    public void mouseReleased(MouseEvent evt) {
        showPopup(evt);
    }

    private void showPopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            thePopupMenu.show(theEditor, evt.getX(), evt.getY());
        }
    }

}

class HammerLogFileFilter extends javax.swing.filechooser.FileFilter {

    public boolean accept(File file) {
        if (file.isDirectory())
            return true;
        String sFileName = file.getName();
        if (sFileName.toLowerCase().endsWith(".log"))
            return true;
        else
            return false;
    }

    public String getDescription() {
        return "Hammer Log Files (*.log)";
    }
}

class HammerLogFileView extends javax.swing.filechooser.FileView {
    // Define the required icon objects.
    ImageIcon projIcon = new ImageIcon("glp_design.gif");

    public String getName(File f) {
        return null;
    }

    public String getDescription(File f) {
        return null;
    }

    public String getTypeDescription(File f) {
        String sExtension = getExtension(f).toLowerCase();
        String sType = null;
        if (sExtension != null) {
            if (sExtension.equals("log"))
                sType = "Hammer Log File";
        }
        return sType;
    }

    public Icon getIcon(File f) {
        String sExtension = getExtension(f);
        Icon theIcon = null;
        if (sExtension != null) {
            if (sExtension.equals("log"))
                theIcon = projIcon;
        }
        return theIcon;
    }

    public Boolean isTraversable(File f) {
        return null;
    }

    private String getExtension(File f) {
        String sFileName = f.getName();
        int iDotIndex = sFileName.lastIndexOf('.');
        String sExtension = null;
        if ((iDotIndex > 0) && (iDotIndex < sFileName.length() - 1))
            sExtension = sFileName.substring(iDotIndex + 1).toLowerCase();
        return sExtension;
    }
}


class HammerConsoleAboutBox extends JAFrame {

    public HammerConsoleAboutBox(HammerLogConsole theIDELogConsole) {
        JATabbedPane theAboutBoxPane = new JATabbedPane();
        ProductInformationPanel theProductInfoPanel = new ProductInformationPanel(theIDELogConsole);
        SystemInformationPanel theSystemInfoPanel = new SystemInformationPanel(theIDELogConsole);
        theAboutBoxPane.addTab("Version Information", theProductInfoPanel);
        theAboutBoxPane.addTab("System Information", theSystemInfoPanel);
        getContentPane().setLayout(new GridLayout(2, 1, 0, 5));
        getContentPane().add(theAboutBoxPane);
        JAPanel theButtonPanel = new JAPanel(new GridBagLayout());
        GridBagConstraints theConstraints = new GridBagConstraints(4, 3, 4, 2, 0, 0, GridBagConstraints.NORTH, 0, new Insets(0, 0, 0, 0), 0, 0);
        getContentPane().add(theButtonPanel);
        JButton theButton = new JButton("Ok");
        theButtonPanel.add(theButton, theConstraints);
        theButton.addActionListener(new AboutBoxButtonListener(this));
        setResizable(true);
        setSize(new Dimension(600, 320));
        show();
    }

    class AboutBoxButtonListener implements ActionListener {
        JAFrame theFrame;

        public AboutBoxButtonListener(JAFrame objFrame) {
            theFrame = objFrame;
        }

        public void actionPerformed(ActionEvent evt) {
            theFrame.hide();
        }
    }

    class ProductInformationPanel extends JAPanel {
        public ProductInformationPanel(HammerLogConsole theIDELogConsole) {
            setLayout(new GridLayout(5, 1));
            add(new JALabel("Hammer Console", JALabel.CENTER));
            add(new JALabel("Version: " + theIDELogConsole.theCreator.theUser.getVersionNumber(), JALabel.CENTER));
            add(new JALabel("Version: " + theIDELogConsole.theCreator.theUser.getRevisionNumber(), JALabel.CENTER));
            add(new JALabel("Version: " + theIDELogConsole.theCreator.theUser.getSubRevisionNumber(), JALabel.CENTER));
            add(new JALabel("Version: " + theIDELogConsole.theCreator.theUser.getBuildNumber(), JALabel.CENTER));
        }
    }

    class SystemPropertyModel extends AbstractTableModel {
        int iRowCount = 0;
        ArrayList ColumnOneValues = new ArrayList(0);
        ArrayList ColumnTwoValues = new ArrayList(0);

        public SystemPropertyModel() {
        }

        public void addPair(String sName, String sValue) {
            ColumnOneValues.add(sName);
            ColumnTwoValues.add(sValue);
        }

        public int getRowCount() {
            return ColumnOneValues.size();
        }

        public Object getValueAt(int iRow, int iCol) {
            if (iCol == 0)
                return ColumnOneValues.get(iRow);
            else
                return ColumnTwoValues.get(iRow);
        }

        public String getColumnName(int iCol) {
            if (iCol == 0)
                return "Property";
            else
                return "Value";
        }

        public int getColumnCount() {
            return 2;
        }
    }

    class SystemInformationPanel extends JAPanel {
        private HammerLogConsole theIDELogConsole;

        public SystemInformationPanel(HammerLogConsole theIDELogConsole) {
            this.theIDELogConsole = theIDELogConsole;
            Properties sysprops = System.getProperties();
            SystemPropertyModel thePropertyModel = new SystemPropertyModel();
            for (Enumeration e = sysprops.propertyNames(); e.hasMoreElements();) {
                String sPropName = (String) e.nextElement();
                String sPropValue = System.getProperty(sPropName);
                thePropertyModel.addPair(sPropName, sPropValue);
            }
            JATable thePropertyTable = new JATable(thePropertyModel);
            setLayout(new BorderLayout());
            add(new JAScrollPane(thePropertyTable));
        }
    }


}
