/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import java.io.OutputStream;
import java.util.ArrayList;

/**
 * <p>Title: Abajamm</p>
 * <p>Description: Abacus Java Module Manager</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: Abacus </p>
 * @author Michael Gouker - Cagey Logic
 * @version 1.0
 */

public class HammerLogOutputStream extends OutputStream {
    ArrayList theLogConsoles = new ArrayList(0);
    public HammerLogConsoleStream theConsoleStream = null;
    public AbaMetaDataUser theUser = null;

    public HammerLogOutputStream(AbaMetaDataUser theUser) {
        this.theUser = theUser;
    }

    void initialize() {  // hooks stream together with console stream
    }

    public void write(int byte_to_write) {
        Thread theRedirectingThread = Thread.currentThread();
        HammerLogConsole theMatchingConsole = getMatchingConsole(theRedirectingThread);
        theMatchingConsole.addByte(byte_to_write);
    }

    public void flush() {
        Thread theRedirectingThread = Thread.currentThread();
        HammerLogConsole theMatchingConsole = getMatchingConsole(theRedirectingThread);
        theMatchingConsole.flush();
    }

    HammerLogConsole getMatchingConsole(Thread theThread) {
        // Won't execute first time guaranteeing a console will be allocated.
        for (int i = 0; i < theLogConsoles.size(); i++) {
            HammerLogConsole theLogConsole = (HammerLogConsole) theLogConsoles.get(i);
//          if ((theServer.theLogFile.bDedicatedConsoles == false) || (theLogConsole.theThread.equals(theThread)))
            return theLogConsole;
        }
        return addLogConsole(theThread);
    }

    HammerLogConsole addLogConsole(Thread theThread) {
        HammerLogConsole theNewConsole = new HammerLogConsole(this);
        theLogConsoles.add(theNewConsole);
        return theNewConsole;
    }

}

