/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.droplets.DropletSimpleLog;


/**
 * Title:        uifactory
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

public class MetaClass {
    public MetaClassDetail theMetadata;
    MetaClass theFirstClass = null;
    MetaClass theLastClass = null;
    MetaClass thePrevSibling = null;
    MetaClass theNextSibling = null;
    MetaClass theParentClass = null;
    MetadataDispenser theMetadataDispenser = null;
    // Object lists by design class.
    public MetaObject theFirstObject = null;
    public MetaObject theLastObject = null;
    public IDEComponentPaletteNode theTreeNode;
    private MetaObject thePrototypeObject;

    public MetaClass(MetaClassDetail theClassMetadata,
                     MetaClass objParent,
                     MetadataDispenser objMetadataDispenser,
                     boolean bMakePrototype) {
        int iMode = objMetadataDispenser.getMetadataUser().getMode();
        theMetadata = theClassMetadata;
        theParentClass = objParent;
        addDefaultListeners(objMetadataDispenser);
        theMetadataDispenser = objMetadataDispenser;
        if (bMakePrototype) {
            // we don't need a prototype class for an instance tracker.
            thePrototypeObject = new MetaObject(theMetadata.sClassName + "_prototype",
                    theMetadata.sClassName,
                    theMetadata.sFullClassName,
                    null,
                    theMetadataDispenser.getPrototypeProject(),
                    iMode,
                    true);
            addObject(thePrototypeObject);
            thePrototypeObject.theClass = this;
        }
    }

    public MetaClass(DropletSimpleLog theLog,
                     MetaClassDetail theClassMetadata,
                     MetaClass objParent,
                     MetadataDispenser objMetadataDispenser) {
        int iMode = objMetadataDispenser.getMetadataUser().getMode();
        theMetadata = theClassMetadata;
        theParentClass = objParent;
        addDefaultListeners(objMetadataDispenser);
        theMetadataDispenser = objMetadataDispenser;
        // this version of the constructor doesn't make the template objects because
        // droplets doesn't use these!!!
    }

    public void setMetadata(MetaClassDetail theClassMetadata) {
        theMetadata = theClassMetadata;
    }

    public MetaClassDetail getMetadata() {
        return theMetadata;
    }

    public boolean getFrame() {
        return theMetadata.containerType.getContainerType() == MetaContainerType.CONTAINER_FRAME;
    }

    public void DeleteClass() {
        if (theParentClass != null) {
            if (theParentClass.theFirstClass.equals(this))
                theParentClass.theFirstClass = theNextSibling;
            else {
                thePrevSibling.theNextSibling = theNextSibling;
            }
            if (theParentClass.theLastClass.equals(this))
                theParentClass.theLastClass = thePrevSibling;
            else
                theNextSibling.thePrevSibling = thePrevSibling;
        } else {
            if (theMetadataDispenser.theFirstClass.equals(this))
                theMetadataDispenser.theFirstClass = theNextSibling;
            else {
                thePrevSibling.theNextSibling = theNextSibling;
            }
            if (theMetadataDispenser.theLastClass.equals(this))
                theMetadataDispenser.theLastClass = thePrevSibling;
            else
                theNextSibling.thePrevSibling = thePrevSibling;
        }
        theNextSibling = thePrevSibling = null;
        theMetadata.DeleteClass();
        theMetadata = null;
    }

    public void addClass(MetaClass newChild) {
        newChild.theParentClass = this;
        if (theLastClass == null)
            theFirstClass = newChild;
        else {
            newChild.thePrevSibling = theLastClass;
            theLastClass.theNextSibling = newChild;
        }
        theLastClass = newChild;
    }

    public MetaMethod getMethod(String sMethodName, boolean bInherit) {
        MetaMethod theMethod = theMetadata.getMethod(sMethodName);
        if ((theMethod == null) && (theParentClass != null) && bInherit)
            theMethod = theParentClass.getMethod(sMethodName, bInherit);
        return theMethod;
    }

    public void setMethod(String sMethodName, String sMethodBody, String sDoc) {
        theMetadata.setMethod(sMethodName, sMethodBody, sDoc);
    }

    public MetaPropertyDescriptor getProperty(String sPropertyName, boolean bInherit) {
        MetaPropertyDescriptor theProperty = theMetadata.getProperty(sPropertyName);
        if ((theProperty == null) && (theParentClass != null) && bInherit)
            theProperty = theParentClass.getProperty(sPropertyName, bInherit);
        return theProperty;
    }

    public void setProperty(MetadataDispenser theMetaProject,
                            String sName, String sTypeName,
                            String sClassName,
                            String[] sValueChoices, String sDoc,
                            String sDefaultValue,
                            String sSetName, String sGetName,
                            String sParseName, String sIncludeTypeConstants, int iOrder) {
        theMetadata.setProperty(theMetaProject,
                sName, sTypeName, sClassName, sValueChoices,
                sDoc,
                sDefaultValue,
                sSetName, sGetName, sParseName, sIncludeTypeConstants, iOrder);
    }

    public MetaDataMember getData(String sMemberName, boolean bInherit) {
        MetaDataMember theData = theMetadata.getData(sMemberName);
        if ((theData == null) && (theParentClass != null) && bInherit)
            theData = theParentClass.getData(sMemberName, bInherit);
        return theData;
    }

    public void setData(String sName, String sTypeName, String sClassName, String sDefaultValue, String sDoc) {
        theMetadata.setData(sName, sTypeName, sClassName, sDefaultValue, sDoc);
    }

    public MetaObject Create(String sObjectName, MetaProject objDesignProject, boolean bTemp) {
        MetaObject theSelectedObject = objDesignProject.getMetaDataUser().getSelectedObject();
        MetaObject theSelectedContainer = objDesignProject.getMetaDataUser().getSelectedContainer();
        MetaObject theParentObject = theSelectedObject;
        // must be a container to have children.
        while ((theParentObject != null) && (theParentObject.getContainerType() == MetaContainerType.CONTAINER_NONE))
            theParentObject = theParentObject.theParentObject;
        if (theParentObject != null) {
            // If it can't be a container than make the parent the selected frame.
            if (theParentObject.theClass.theMetadata.containerType.getContainerType() == MetaContainerType.CONTAINER_NONE)
                theParentObject = theSelectedContainer;
        } else
            theParentObject = theSelectedContainer;


        MetaObject theObject = new MetaObject(sObjectName,
                theMetadata.sClassName,
                theMetadata.sFullClassName,
                theParentObject,
                objDesignProject,
                objDesignProject.iMode,
                true);
        // Add to parent always even for clones in clipboard
        // It's not really included until the object is added to an object of the project
        // or to the project.
        if (theParentObject != null)
            theParentObject.addObject(theObject);
        else
            objDesignProject.addObject(theObject);
        return theObject;
    }

    public String getNextSubclassName() {
        int iAutoClasses = 0;
        MetaClass theClass = this.theFirstClass;
        String sPrefix = theMetadata.sClassName + "Subclass";
        while (true) {
            while (theClass != null) {
                if (theClass.theMetadata.sClassName.equals(sPrefix + iAutoClasses))
                    break;
                theClass = theClass.theNextSibling;
            }
            if (theClass == null)
                return sPrefix + iAutoClasses;
            iAutoClasses++;
        }
    }

    public MetaClass addClass(electric.xml.Element theClassDescription) {
        return theMetadataDispenser.theMetadataDocument.loadClass(theClassDescription, this);
    }

    public MetaClass subclassClass(String sPackageName, int iMode) {
        // Make a child class of this class.
        String sClassName = getNextSubclassName();
        String sNewFullClassName = theMetadata.sFullClassName.substring(0, theMetadata.sFullClassName.lastIndexOf(".")) + sClassName;
        MetaClassDetail theClass = new MetaClassDetail(sClassName, sNewFullClassName);
        MetaClass theMetaClass = new MetaClass(theClass, this, theMetadataDispenser, true);
        String sSuperClassName = theMetadata.sClassName;
        String sFullPathName = (sPackageName == null) ? theMetadata.sClassName :
                sPackageName + "." + theMetadata.sClassName;
        theClass.setSuperClass(sSuperClassName, sFullPathName);
        theClass.setDisplayClass(theMetadata.sDisplayClass);  // Use same display class.
        theClass.containerType = theMetadata.containerType;
        addClass(theMetaClass);
        return theMetaClass;
    }

    //  Listeners

    public void addDefaultListeners(MetadataDispenser theMetadataDispenser) {
        if (theMetadata.bDefaultListeners == true)
            theMetadata.addDefaultListeners(theMetadataDispenser);
    }

    public MetaClassDetail getListener(String sListenerName) {
        MetaClassDetail theListener = theMetadata.getListener(sListenerName);
        if ((theListener == null) && (theParentClass != null))
            return theParentClass.getListener(sListenerName);
        else
            return theListener; // may be null if no parent.
    }

    // Add listeners to all objects of all subclasses.
    void addListenerHelper() {
        MetaObject theObject = theFirstObject;
        while (theObject != null) {
            theObject.addAllMethods();
            theObject = theObject.theNextObject;
        }
        MetaClass objClass = theFirstClass;
        while (objClass != null) {
            objClass.addListenerHelper();
            objClass = objClass.theNextSibling;
        }
    }

    // Design project keeps track of all listeners.
    public void addListener(String sListenerName, MetadataDispenser theMetadataDispenser) {
        theMetadata.addListener(sListenerName, theMetadataDispenser);
        addListenerHelper();
    }

    public boolean removeListener(String sListenerName) {
        // do not automatically remove methods from objects when we delete a listener
        return theMetadata.removeListener(sListenerName);
    }

    public void addObject(MetaObject theNewObject) {
        if (theFirstObject == null)
            theFirstObject = theNewObject;
        else {
            theLastObject.theNextInstance = theNewObject;
            theNewObject.thePreviousInstance = theLastObject;
        }
        theLastObject = theNewObject;
    }

    public void removeObject(MetaObject theLateObject) {
        if (theLateObject.equals(theFirstObject))
            theFirstObject = theLateObject.theNextInstance;
        else
            theLateObject.thePreviousInstance.theNextInstance = theLateObject.theNextInstance;
        if (theLateObject.equals(theLastObject))
            theLastObject = theLateObject.thePreviousInstance;
        else
            theLateObject.theNextInstance.thePreviousInstance = theLateObject.thePreviousInstance;
    }

    public void setUsage() {
        MetaClass theChild = theFirstClass;
        while (theChild != null) {
            theChild.setUsage();
            theChild = theChild.theNextSibling;
        }
        if ((theMetadata.bUsed == false) && (theFirstObject != null)) {
            if (theMetadata.bUsed == false) {
                theMetadata.bUsed = true;
                MetaClass theParent = theParentClass;
                while (theParent != null) {
                    theParent.theMetadata.bUsed = true;
                    theParent = theParent.theParentClass;
                }
            }
        }
    }

    public int getPropertyCount(boolean bInherits) {
        int iProps = theMetadata.iNumberOfProperties;
        if (bInherits && (theParentClass != null))
            iProps += theParentClass.getPropertyCount(true);
        return iProps;
    }

    public int getMethodCount(boolean bInherits) {
        int iMeths = theMetadata.iNumberOfMethods;
        if (bInherits && (theParentClass != null))
            iMeths += theParentClass.getMethodCount(true);
        return iMeths;
    }

    public int getDataElementCount(boolean bInherits) {
        int iElements = theMetadata.iNumberOfDataElements;
        if (bInherits && (theParentClass != null))
            iElements += theParentClass.getDataElementCount(true);
        return iElements;
    }

    public MetaClass getNextSibling() {
        return this.theNextSibling;
    }

    public MetaClass getFirstClass() {
        return this.theFirstClass;
    }

    public MetaClass getLastClass() {
        return this.theLastClass;
    }

    public MetaClass getParentClass() {
        return this.theParentClass;
    }

    public void setNextSibling(MetaClass theNewClass) {
        theNextSibling = theNewClass;
    }

    public void setPrevSibling(MetaClass theNewClass) {
        thePrevSibling = theNewClass;
    }

    public MetaProperty getDefaultProperty(String theName) {
        MetaPropertyDescriptor thePropertyInfo = this.getProperty(theName, true);
        if ((thePrototypeObject != null) && (thePropertyInfo != null)) {
            MetaProperty thePropertyRecord = thePrototypeObject.getPropertyMetadata(theName);
            if (thePropertyRecord != null)
                return thePropertyRecord;
            thePrototypeObject.addDefaultProperty(null, thePropertyInfo);
            return thePrototypeObject.getPropertyMetadata(theName);
        }
        return null;
    }

    public MetaClass emptyClone() {
        MetaClass retValue = new MetaClass(this.theMetadata, null, theMetadataDispenser, false);
        return retValue;
    }

    public MetaClass addInstanceTracker(MetaClass srcClass) {
        MetaClass newClass = srcClass.emptyClone();
        addClass(newClass);
        return newClass;
    }

    public boolean hasRealObjects() {
        if (theLastObject==null)
            return false;
        if (thePrototypeObject==null)
            return false;
        // return true if there are real objects (not just prototype)
        if (theFirstObject.theNextInstance!=null)
            return true;
        return !(theLastObject.equals(thePrototypeObject));
    }
}