/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * Title:        uifactory
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

public class MetaProjectHeader {
    public boolean bAbalet = false;
    public boolean bApplication = false;
    public boolean bGeneratePLAF = false;
    public MetaClassDetail theFirstClass = null;
    public MetaClassDetail theLastClass = null;
    public MetaObject theMainObject = null;
    public MetaImport theFirstImport = null;
    public MetaImport theLastImport = null;

    public String sMainClass = null;
    public String sPackageName = null;
    public String sOutputDirectory = null;
    public String sCodeGenerationDocument = null;
    public String sAuthor = null;
    public String sDescription = null;
    public String sWorkspace = null;
    public String sProjectName = null;
    public String sTransientDirectory = null;
    public String sPlatformLookAndFeel = null;
    public String sGenLookFeelName = null;
    public boolean bNLSTranslation = true;
    public boolean bAccesorCode = true;


//    public String sStickyDelimiters = null;
//    public String sDelimiters = null;
//    public int iIndentation = 0;
//    public int iMaxLineLength = 0;
    public ArrayList additionalClassPaths = new ArrayList(0);

    public MetaProjectHeader(HashMap thePreferences) {
        AddImport("java.io.*");
        AddImport("java.awt.*");
        AddImport("java.util.*");
        AddImport("javax.swing.*");
        AddImport("javax.swing.text.*");
        AddImport("javax.swing.plaf.*");
        AddImport("java.lang.reflect.*");
        AddImport("java.awt.event.*");
        AddImport("javax.swing.event.*");
        AddImport("ch.abacus.lib.ui.*");
        AddImport("ch.abacus.lib.ui.layout.*");
        AddImport("ch.abacus.lib.ui.renderer.common.jdbc.*"); // MHC
        sProjectName = "New Project";
        sAuthor = (String) thePreferences.get("Author");
        sPlatformLookAndFeel = (String) thePreferences.get("LNF");
        sCodeGenerationDocument = (String) thePreferences.get("MetadataDocument");
        sWorkspace = (String) thePreferences.get("Workspace");
        sTransientDirectory = (String) thePreferences.get("Transient");
    }

    public void AddImport(String sPackageName) {
        MetaImport theNewImport = new MetaImport(sPackageName);
        if (theFirstImport == null)
            theFirstImport = theNewImport;
        else
            theLastImport.theNextImport = theNewImport;
        theLastImport = theNewImport;
    }

    public boolean FindImport(String sPackageName) {
        MetaImport theImport = theFirstImport;
        while (theImport != null) {
            if (theImport.sImportName.equals(sPackageName))
                return true;
            theImport = theImport.theNextImport;
        }
        return false;
    }

    public void AddClassPath(String sDirectoryName) {
        additionalClassPaths.add(sDirectoryName);
    }

    public int getAdditionalClassPathCount() {
        return additionalClassPaths.size();
    }

    public String getAdditionalClassPath(int i) {
        return (String) additionalClassPaths.get(i);
    }

    public void setClassPath(String s) {
        int iMatch = s.indexOf(";");
        while (iMatch != -1) {
            String sLeft = s.substring(0, iMatch);
            AddClassPath(sLeft);
            s = s.substring(iMatch + 1);
            iMatch = s.indexOf(";");
        }
    }

    public String getClassPath() {
        int i = 0;
        String sClassPath = "";
        String sPathSeparator = System.getProperty("path.separator");
        for (i = 0; i < getAdditionalClassPathCount(); i++) {
            sClassPath = sClassPath + getAdditionalClassPath(i) + sPathSeparator;
        }
        return sClassPath;
    }

    public void addClass(MetaClassDetail theClass) {
        if (theFirstClass == null)
            theFirstClass = theClass;
        else
            theLastClass.theNextClass = theClass;
        theLastClass = theClass;
    }

    public boolean isbAccesorCode() {
        return bAccesorCode;
    }

    public void setbAccesorCode(boolean bAccesorCode) {
        this.bAccesorCode = bAccesorCode;
    }

    public boolean isbNLSTranslation() {
        return bNLSTranslation;
    }

    public void setbNLSTranslation(boolean bNLSTranslation) {
        this.bNLSTranslation = bNLSTranslation;
    }

}

