/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common.jdbc;

/* Alpha Version */

import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaObjectAccess;
import com.nqadmin.swingSet.SSTextDocument;
import com.nqadmin.swingSet.SSTextField;

import javax.sql.RowSet;
import java.util.ArrayList;


/**
 * Created by IntelliJ IDEA.
 * User: Mario
 * Date: Mar 15, 2004
 * Time: 3:10:47 AM
 * To change this template use Options | File Templates.
 */
public class JSSTextField extends SSTextField implements MetaObjectAccess {
    public  String          FieldName = null;
    public  RowSet          rs = null;
    private SSTextDocument  sstxdoc = null;
    private JSSDataSource   editDataSource = null;
    private int             iDesignMode = 0;

    public JSSTextField() {
        super();
    }

    public JSSTextField(JSSDataSource ds) {
        super();
    }

    // Just for release 1.2
    public void setText(String data) {
        if (this.iDesignMode == 0) {
            super.setText(data);
        }
    }

    public void setMetaObject(MetaObject ideMetaObject) {
        iDesignMode = ideMetaObject.iMode;
    }

    private void setRowSet() {
     try
     {
        if (rs != null && FieldName != null && FieldName.length() > 0) {
            sstxdoc = new SSTextDocument(this.rs, FieldName);
            this.setDocument(sstxdoc);
        }
     }
     catch (Exception e)
     {
         e.printStackTrace();
     }
    }

    public void setDataSource(JSSDataSource ds) {
        editDataSource = ds;
        try {
            if (this.iDesignMode == 0 || ds != null) {
                this.rs = ds.getRowSet();
                this.setRowSet();
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFieldName(String sData) {
        FieldName = sData;
        try {
            this.setRowSet();
        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    public void setSSMask(int mask) {
        this.setMask(mask);
    }

    public ArrayList getFieldNames() {
        if(editDataSource==null)
            return null;
        else
            return editDataSource.getFieldNames();
    }

}
