/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * IgnoreStandardEventsInterface.java  
 *
 * Creator:
 * 05.03.2004 14:37:05 lauchenauer
 *
 * Maintainer:
 * 05.03.2004 14:37:05 lauchenauer
 *
 * Last Modification:
 * $Id: IgnoreStandardEventsInterface.java,v 1.2 2005/10/19 07:07:48 graeulich Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */
package ch.abacus.lib.ui.validation;

/**
 * This interface is only used to identify components that should ignore the StandardEvents. The behavior is the
 * following. As example we have a container with 4 components, components a, b, and c are standard components, d
 * implements the interface. This could be a dialog with 3 entries on it and d being the cancel button.
 *
 * The behavior is the following:
 * - if component d is clicked with the mouse no abaValidate nor requestExit events are fired on the last component
 * - if component d is entered through keyboard navigation the previous component will get the abaValidate and
 *    requestExit events
 * - component d will never get any of the StandardEvents, such as abaValidate, requestEnter, requestExit
 */
public interface IgnoreStandardEventsInterface {

    /**
     * Property for AbaKeyboardFocusManager to check whether it should enable validation for this component or not.
     *
     * @return
     */
    public boolean isValidationIndependent();
}
