/**
 * FontSelectorBean.java  1.00 97/08/09 Merlin Hughes
 *
 * Copyright (c) 1997 Merlin Hughes, All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * for commercial and non-commercial purposes and without fee is
 * hereby granted provided that this copyright notice appears in
 * all copies.
 *
 * http://prominence.com/                         ego@merlin.org
 */

package org.merlin.beans.font;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.beans.*;
import java.awt.event.*;

public class FontSelectorBean extends JFrame implements ItemSelectable {
  protected JLabel label;
  protected FontChooserBean chooser;

  public FontSelectorBean () {
    Container container = getContentPane();
    container.setLayout (new GridLayout (2, 1));

    JPanel p = new JPanel ();
    container.add (p);
    p.setLayout (new BorderLayout ());
    JPanel q = new JPanel ();
    q.setLayout (new GridLayout (2, 1));
    JButton okay = new JButton ("OK");
    JButton cancel = new JButton ("Cancel");
    q.add (okay);
    q.add (cancel);
    p.add ("East", q);
    try {
      chooser = (FontChooserBean) Beans.instantiate (getClass ().getClassLoader (), "org.merlin.beans.font.FontChooserBean");
    } catch (Exception ex) {
      ex.printStackTrace ();
    }
    p.add ("Center", (Component) Beans.getInstanceOf (chooser, Component.class));

    final JPanel sample = new JPanel ();
    sample.setLayout (new CardLayout ());
    final JTextField field = new JTextField ("abcABC012...");
    label = new JLabel (field.getText (), JLabel.CENTER);
    sample.add ("label", label);
    sample.add ("field", field);
    container.add (sample);

    chooser.addPropertyChangeListener (new PropertyChangeListener () {
      public void propertyChange (PropertyChangeEvent e) {
        label.setFont ((Font) e.getNewValue ());
      }
    });

    okay.addActionListener (new ActionListener () {
      public void actionPerformed (ActionEvent e) {
        fireSelection (true);
      }
    });

    cancel.addActionListener (new ActionListener () {
      public void actionPerformed (ActionEvent e) {
        fireSelection (false);
      }
    });

    label.addMouseListener (new MouseAdapter () {
      public void mousePressed (MouseEvent e) {
        ((CardLayout) sample.getLayout ()).show (sample, "field");
      }
    });

    field.addComponentListener (new ComponentAdapter () {
      public void componentShown (ComponentEvent e) {
        field.selectAll ();
        field.requestFocus ();
      }
    });

    field.addActionListener (new ActionListener () {
      public void actionPerformed (ActionEvent e) {
        label.setText (field.getText ());
        ((CardLayout) sample.getLayout ()).show (sample, "label");
      }
    });

  }

  public void setStyle (Font f) {
    label.setFont (f);
    chooser.setStyle (f);
  }

  public Font getStyle () {
    return chooser.getStyle ();
  }

  public Object[] getSelectedObjects () {
    Font[] fonts = { getStyle () };
    return fonts;
  }

  protected ItemListener listeners;

  public void addItemListener (ItemListener l) {
    listeners = AWTEventMulticaster.add (l, listeners);
  }

  public void removeItemListener (ItemListener l) {
    listeners = AWTEventMulticaster.remove (l, listeners);
  }

  protected void fireSelection (boolean okay) {
    if (listeners != null)
      listeners.itemStateChanged (
        new ItemEvent (this, ItemEvent.ITEM_STATE_CHANGED, getStyle  (),
                       okay ? ItemEvent.SELECTED : ItemEvent.DESELECTED));
  }
}
